/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.config;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.web.conf.HeaderFactory;
import java.util.Collections;
import java.util.Map;

public class ReferrerPolicyHeaderFactory
extends HeaderFactory {
    public static final String REFERRER_POLICY_HEADER = "Referrer-Policy";
    @JsonProperty
    private ReferrerPolicyOption option = ReferrerPolicyOption.NO_REFERRER;

    public ReferrerPolicyOption getOption() {
        return this.option;
    }

    public void setOption(ReferrerPolicyOption option) {
        this.option = option;
    }

    public Map<String, String> buildHeaders() {
        return Collections.singletonMap(REFERRER_POLICY_HEADER, this.option.getValue());
    }

    public static enum ReferrerPolicyOption {
        NO_REFERRER("no-referrer"),
        NO_REFERRER_WHEN_DOWNGRADE("no-referrer-when-downgrade"),
        ORIGIN("origin"),
        ORIGIN_WHEN_CROSS_ORIGIN("origin-when-cross-origin"),
        SAME_ORIGIN("same-origin"),
        STRICT_ORIGIN("strict-origin"),
        STRICT_ORIGIN_WHEN_CROSS_ORIGIN("strict-origin-when-cross-origin"),
        UNSAFE_URL("unsafe-url");

        private final String value;

        private ReferrerPolicyOption(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

