/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Database;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;

public class DatabaseSchemaRepository
extends EntityRepository<DatabaseSchema> {
    public DatabaseSchemaRepository(CollectionDAO dao) {
        super("v1/databaseSchemas/", "databaseSchema", DatabaseSchema.class, dao.databaseSchemaDAO(), dao, "", "");
    }

    @Override
    public void setFullyQualifiedName(DatabaseSchema schema) {
        schema.setFullyQualifiedName(FullyQualifiedName.add(schema.getDatabase().getFullyQualifiedName(), schema.getName()));
    }

    @Override
    public void prepare(DatabaseSchema schema) {
        this.populateDatabase(schema);
    }

    @Override
    public void storeEntity(DatabaseSchema schema, boolean update) {
        EntityReference service = schema.getService();
        schema.withService(null);
        this.store(schema, update);
        schema.withService(service);
    }

    @Override
    public void storeRelationships(DatabaseSchema schema) {
        EntityReference database = schema.getDatabase();
        this.addRelationship(database.getId(), schema.getId(), database.getType(), "databaseSchema", Relationship.CONTAINS);
    }

    private List<EntityReference> getTables(DatabaseSchema schema) {
        return schema == null ? Collections.emptyList() : this.findTo(schema.getId(), "databaseSchema", Relationship.CONTAINS, "table");
    }

    @Override
    public DatabaseSchema setFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        this.setDefaultFields(schema);
        schema.setTables(fields.contains("tables") ? this.getTables(schema) : null);
        return schema.withUsageSummary(fields.contains("usageSummary") ? EntityUtil.getLatestUsage(this.daoCollection.usageDAO(), schema.getId()) : null);
    }

    @Override
    public DatabaseSchema clearFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        schema.setTables(fields.contains("tables") ? schema.getTables() : null);
        return schema.withUsageSummary(fields.contains("usageSummary") ? schema.getUsageSummary() : null);
    }

    private void setDefaultFields(DatabaseSchema schema) {
        EntityReference databaseRef = this.getContainer(schema.getId());
        Database database = (Database)Entity.getEntity(databaseRef, "", Include.ALL);
        schema.withDatabase(databaseRef).withService(database.getService());
    }

    @Override
    public DatabaseSchema setInheritedFields(DatabaseSchema schema, EntityUtil.Fields fields) {
        Database database = null;
        UUID databaseId = schema.getDatabase().getId();
        if (fields.contains("owner") && schema.getOwner() == null) {
            database = (Database)Entity.getEntity("database", databaseId, "owner", Include.ALL);
            schema.withOwner(database.getOwner());
        }
        if (schema.getRetentionPeriod() == null) {
            database = database == null ? (Database)Entity.getEntity("database", databaseId, "", Include.ALL) : database;
            schema.withRetentionPeriod(database.getRetentionPeriod());
        }
        return schema;
    }

    @Override
    public void restorePatchAttributes(DatabaseSchema original, DatabaseSchema updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withName(original.getName()).withService(original.getService()).withId(original.getId());
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(DatabaseSchema original, DatabaseSchema updated, EntityRepository.Operation operation) {
        return new DatabaseSchemaUpdater(original, updated, operation);
    }

    private void populateDatabase(DatabaseSchema schema) {
        Database database = (Database)Entity.getEntity(schema.getDatabase(), "", Include.ALL);
        schema.withDatabase(database.getEntityReference()).withService(database.getService()).withServiceType(database.getServiceType());
        schema.withOwner(schema.getOwner() == null ? database.getOwner() : schema.getOwner());
    }

    public class DatabaseSchemaUpdater
    extends EntityRepository.EntityUpdater {
        public DatabaseSchemaUpdater(DatabaseSchema original, DatabaseSchema updated, EntityRepository.Operation operation) {
            super((EntityRepository)DatabaseSchemaRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.recordChange("retentionPeriod", ((DatabaseSchema)this.original).getRetentionPeriod(), ((DatabaseSchema)this.updated).getRetentionPeriod());
            this.recordChange("sourceUrl", ((DatabaseSchema)this.original).getSourceUrl(), ((DatabaseSchema)this.updated).getSourceUrl());
        }
    }
}

