/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.schema.ColumnsEntityInterface;
import org.openmetadata.schema.api.lineage.AddLineage;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.ColumnLineage;
import org.openmetadata.schema.type.Edge;
import org.openmetadata.schema.type.EntityLineage;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.LineageDetails;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class LineageRepository {
    private final CollectionDAO dao;

    public LineageRepository(CollectionDAO dao) {
        this.dao = dao;
    }

    @Transaction
    public EntityLineage get(String entityType, String id, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceById(entityType, UUID.fromString(id), Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    @Transaction
    public EntityLineage getByName(String entityType, String fqn, int upstreamDepth, int downstreamDepth) {
        EntityReference ref = Entity.getEntityReferenceByName(entityType, fqn, Include.NON_DELETED);
        return this.getLineage(ref, upstreamDepth, downstreamDepth);
    }

    @Transaction
    public void addLineage(AddLineage addLineage) {
        EntityReference from = addLineage.getEdge().getFromEntity();
        from = Entity.getEntityReferenceById(from.getType(), from.getId(), Include.NON_DELETED);
        EntityReference to = addLineage.getEdge().getToEntity();
        to = Entity.getEntityReferenceById(to.getType(), to.getId(), Include.NON_DELETED);
        if (addLineage.getEdge().getLineageDetails() != null && addLineage.getEdge().getLineageDetails().getPipeline() != null) {
            EntityReference pipeline = addLineage.getEdge().getLineageDetails().getPipeline();
            pipeline = Entity.getEntityReferenceById(pipeline.getType(), pipeline.getId(), Include.NON_DELETED);
            addLineage.getEdge().getLineageDetails().withPipeline(pipeline);
        }
        String detailsJson = this.validateLineageDetails(from, to, addLineage.getEdge().getLineageDetails());
        this.dao.relationshipDAO().insert(from.getId(), to.getId(), from.getType(), to.getType(), Relationship.UPSTREAM.ordinal(), detailsJson);
    }

    private String validateLineageDetails(EntityReference from, EntityReference to, LineageDetails details) {
        if (details == null) {
            return null;
        }
        List columnsLineage = details.getColumnsLineage();
        if (columnsLineage != null && !columnsLineage.isEmpty()) {
            if (this.areValidEntities(from, to)) {
                throw new IllegalArgumentException("Column level lineage is only allowed between two tables or from table to dashboard.");
            }
            Table fromTable = (Table)this.dao.tableDAO().findEntityById(from.getId());
            ColumnsEntityInterface toTable = this.getToEntity(to);
            for (ColumnLineage columnLineage : columnsLineage) {
                for (String fromColumn : columnLineage.getFromColumns()) {
                    if (fromColumn.startsWith(fromTable.getFullyQualifiedName())) {
                        ColumnUtil.validateColumnFQN(fromTable.getColumns(), fromColumn);
                        continue;
                    }
                    Table otherTable = (Table)this.dao.tableDAO().findEntityByName(FullyQualifiedName.getTableFQN(fromColumn));
                    ColumnUtil.validateColumnFQN(otherTable.getColumns(), fromColumn);
                }
                ColumnUtil.validateColumnFQN(toTable.getColumns(), columnLineage.getToColumn());
            }
        }
        return JsonUtils.pojoToJson(details);
    }

    private ColumnsEntityInterface getToEntity(EntityReference from) {
        return from.getType().equals("table") ? (ColumnsEntityInterface)this.dao.tableDAO().findEntityById(from.getId()) : (ColumnsEntityInterface)this.dao.dashboardDataModelDAO().findEntityById(from.getId());
    }

    private boolean areValidEntities(EntityReference from, EntityReference to) {
        return !from.getType().equals("table") || !to.getType().equals("table") && !to.getType().equals("dashboardDataModel");
    }

    @Transaction
    public boolean deleteLineage(String fromEntity, String fromId, String toEntity, String toId) {
        EntityReference from = Entity.getEntityReferenceById(fromEntity, UUID.fromString(fromId), Include.NON_DELETED);
        EntityReference to = Entity.getEntityReferenceById(toEntity, UUID.fromString(toId), Include.NON_DELETED);
        return this.dao.relationshipDAO().delete(from.getId().toString(), from.getType(), to.getId().toString(), to.getType(), Relationship.UPSTREAM.ordinal()) > 0;
    }

    private EntityLineage getLineage(EntityReference primary, int upstreamDepth, int downstreamDepth) {
        ArrayList entities = new ArrayList();
        EntityLineage lineage = new EntityLineage().withEntity(primary).withNodes(entities).withUpstreamEdges(new ArrayList()).withDownstreamEdges(new ArrayList());
        this.getUpstreamLineage(primary.getId(), primary.getType(), lineage, upstreamDepth);
        this.getDownstreamLineage(primary.getId(), primary.getType(), lineage, downstreamDepth);
        lineage.withNodes(lineage.getNodes().stream().distinct().collect(Collectors.toList()));
        return lineage;
    }

    private void getUpstreamLineage(UUID id, String entityType, EntityLineage lineage, int upstreamDepth) {
        if (upstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") ? this.dao.relationshipDAO().findFromPipleine(id.toString(), Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findFrom(id.toString(), entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> upstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            upstreamEntityReferences.add(ref);
            lineage.getUpstreamEdges().add(new Edge().withFromEntity(ref.getId()).withToEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(upstreamEntityReferences);
        --upstreamDepth;
        for (EntityReference entity : upstreamEntityReferences) {
            this.getUpstreamLineage(entity.getId(), entity.getType(), lineage, upstreamDepth);
        }
    }

    private void getDownstreamLineage(UUID id, String entityType, EntityLineage lineage, int downstreamDepth) {
        if (downstreamDepth == 0) {
            return;
        }
        List<CollectionDAO.EntityRelationshipRecord> records = entityType.equals("pipeline") ? this.dao.relationshipDAO().findToPipeline(id.toString(), Relationship.UPSTREAM.ordinal()) : this.dao.relationshipDAO().findTo(id.toString(), entityType, Relationship.UPSTREAM.ordinal());
        ArrayList<EntityReference> downstreamEntityReferences = new ArrayList<EntityReference>();
        for (CollectionDAO.EntityRelationshipRecord entityRelationshipRecord : records) {
            EntityReference ref = Entity.getEntityReferenceById(entityRelationshipRecord.getType(), entityRelationshipRecord.getId(), Include.ALL);
            LineageDetails lineageDetails = JsonUtils.readValue(entityRelationshipRecord.getJson(), LineageDetails.class);
            downstreamEntityReferences.add(ref);
            lineage.getDownstreamEdges().add(new Edge().withToEntity(ref.getId()).withFromEntity(id).withLineageDetails(lineageDetails));
        }
        lineage.getNodes().addAll(downstreamEntityReferences);
        --downstreamDepth;
        for (EntityReference entity : downstreamEntityReferences) {
            this.getDownstreamLineage(entity.getId(), entity.getType(), lineage, downstreamDepth);
        }
    }
}

