/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.postgres.v110;

import org.jdbi.v3.core.Handle;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.migration.api.MigrationProcessImpl;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.migration.utils.v110.MigrationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
extends MigrationProcessImpl {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);
    private CollectionDAO collectionDAO;
    private Handle handle;

    public Migration(MigrationFile migrationFile) {
        super(migrationFile);
    }

    @Override
    public void initialize(Handle handle) {
        super.initialize(handle);
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
    }

    @Override
    public void runDataMigration() {
        String envVariableValue = System.getenv("MIGRATION_LIMIT_PARAM");
        if (envVariableValue != null) {
            MigrationUtil.dataMigrationFQNHashing(this.handle, this.collectionDAO, Integer.parseInt(envVariableValue));
        } else {
            MigrationUtil.dataMigrationFQNHashing(this.handle, this.collectionDAO, 1000);
        }
    }

    @Override
    public void runPostDDLScripts() {
        super.runPostDDLScripts();
        MigrationUtil.testSuitesMigration(this.collectionDAO);
    }
}

