/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.postgres.v112;

import java.util.List;
import java.util.Set;
import org.jdbi.v3.core.Handle;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.schema.tests.TestSuite;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.utils.EntityInterfaceUtil;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.TestSuiteRepository;
import org.openmetadata.service.migration.api.MigrationProcessImpl;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
extends MigrationProcessImpl {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);
    private CollectionDAO collectionDAO;
    private Handle handle;

    public Migration(MigrationFile migrationFile) {
        super(migrationFile);
    }

    @Override
    public void initialize(Handle handle) {
        super.initialize(handle);
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
    }

    @Override
    public void runDataMigration() {
        Migration.unquoteTestSuiteMigration(this.collectionDAO);
        Migration.lowerCaseUserNameAndEmail(this.collectionDAO);
    }

    public static void unquoteTestSuiteMigration(CollectionDAO collectionDAO) {
        TestSuiteRepository testSuiteRepository = new TestSuiteRepository(collectionDAO);
        List testSuites = testSuiteRepository.listAll(new EntityUtil.Fields(Set.of("id")), new ListFilter(Include.ALL));
        for (TestSuite suite : testSuites) {
            String fqn;
            if (!Boolean.TRUE.equals(suite.getExecutable())) continue;
            String updatedFqn = fqn = suite.getFullyQualifiedName();
            if (fqn.startsWith("\"") && fqn.endsWith("\"")) {
                updatedFqn = fqn.substring(1, fqn.length() - 1);
            }
            suite.setName(updatedFqn);
            suite.setFullyQualifiedName(updatedFqn);
            collectionDAO.testSuiteDAO().update((EntityInterface)suite);
        }
    }

    public static void lowerCaseUserNameAndEmail(CollectionDAO daoCollection) {
        LOG.debug("Starting Migration UserName and Email to Lowercase");
        int total = daoCollection.userDAO().listTotalCount();
        int limit = 200;
        for (int offset = 0; offset < total; offset += limit) {
            List<String> userEntities = daoCollection.userDAO().listAfterWithOffset(limit, offset);
            for (String json : userEntities) {
                User userEntity = JsonUtils.readValue(json, User.class);
                userEntity.setFullyQualifiedName(EntityInterfaceUtil.quoteName((String)userEntity.getFullyQualifiedName().toLowerCase()));
                daoCollection.userDAO().update((EntityInterface)userEntity);
            }
        }
        LOG.debug("Completed Migrating UserName and Email to Lowercase");
    }
}

