/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.analytics;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.analytics.WebAnalyticEvent;
import org.openmetadata.schema.analytics.WebAnalyticEventData;
import org.openmetadata.schema.analytics.type.WebAnalyticEventType;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.api.tests.CreateWebAnalyticEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.jdbi3.WebAnalyticEventRepository;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/v1/analytics/web/events")
@Tag(name="Data Insights", description="APIs related to Data Insights data and charts.")
@Hidden
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="analytics")
public class WebAnalyticEventResource
extends EntityResource<WebAnalyticEvent, WebAnalyticEventRepository> {
    private static final Logger LOG = LoggerFactory.getLogger(WebAnalyticEventResource.class);
    public static final String COLLECTION_PATH = "/v1/analytics/web/events";
    static final String FIELDS = "owner";

    @Override
    public WebAnalyticEvent addHref(UriInfo uriInfo, WebAnalyticEvent entity) {
        entity.withHref(RestUtil.getHref(uriInfo, COLLECTION_PATH, entity.getId()));
        Entity.withHref(uriInfo, entity.getOwner());
        return entity;
    }

    public WebAnalyticEventResource(CollectionDAO dao, Authorizer authorizer) {
        super(WebAnalyticEvent.class, new WebAnalyticEventRepository(dao), authorizer);
    }

    @Override
    public void initialize(OpenMetadataApplicationConfig config) throws IOException {
        List webAnalyticEvents = ((WebAnalyticEventRepository)this.repository).getEntitiesFromSeedData(".*json/data/analytics/webAnalyticEvents/.*\\.json$");
        for (WebAnalyticEvent webAnalyticEvent : webAnalyticEvents) {
            ((WebAnalyticEventRepository)this.repository).initializeEntity(webAnalyticEvent);
        }
    }

    @GET
    @Operation(operationId="listWebAnalyticEventTypes", summary="List web analytic event types", description="Get a list of web analytics event types.Use field parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of web analytic event types", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEventList.class))})})
    public ResultList<WebAnalyticEvent> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Limit the number report Definition returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of report definitions before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of report definitions after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include);
        return super.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @Override
    @POST
    @Operation(operationId="createWebAnalyticEventType", summary="Create a web analytic event type", description="Create a web analytic event type", responses={@ApiResponse(responseCode="200", description="Create a web analytic event type", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWebAnalyticEvent create) {
        WebAnalyticEvent webAnalyticEvent = this.getWebAnalyticEvent(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, webAnalyticEvent);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateWebAnalyticEventType", summary="Update a web analytic event type", description="Update web analytic event type.", responses={@ApiResponse(responseCode="200", description="Updated web analytic event type", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateWebAnalyticEvent create) {
        WebAnalyticEvent webAnalyticEvent = this.getWebAnalyticEvent(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, webAnalyticEvent);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getWebAnalyticEventTypeById", summary="Get a web analytic event type by Id", description="Get a web analytic event type by `Id`.", responses={@ApiResponse(responseCode="200", description="A web analytic event type", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))}), @ApiResponse(responseCode="404", description="Web Analytic Event for instance {id} is not found")})
    public WebAnalyticEvent get(@Context UriInfo uriInfo, @Parameter(description="Id of the web analytic event", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (WebAnalyticEvent)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchWebAnalyticEventTypeById", summary="Update a web analytic event type by Id", description="Update a web analytic event type.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response updateDescription(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the web analytic event", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteWebAnalyticEventTypeById", summary="Delete a web analytic event type by Id", description="Delete a web analytic event type by Id.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Web Analytic event for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Id of the web analytic event", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, false, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteWebAnalyticEventTypeByName", summary="Delete a web analytic event type by fully qualified name", description="Delete a web analytic event type by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Web Analytic event for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Fully qualified name of the web analytic event", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted web analytic event", description="Restore a soft deleted web analytic event.", responses={@ApiResponse(responseCode="200", description="Successfully restored the WebAnalyticEvent. ", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))})})
    public Response restoreWebAnalyticEvent(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getWebAnalyticEventTypeByName", summary="Get a web analytic event type by fully qualified name", description="Get a web analytic event type by `fullyQualifiedName`.", responses={@ApiResponse(responseCode="200", description="A web analytic event type", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))}), @ApiResponse(responseCode="404", description="Web Analytic event type for instance {fqn} is not found")})
    public WebAnalyticEvent getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the web analytic event", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (WebAnalyticEvent)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllWebAnalyticEventTypeVersion", summary="List web analytic event type versions", description="Get a list of all the version of a web analytic event type by `Id`.", responses={@ApiResponse(responseCode="200", description="List all web analytic event type versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the web analytic event", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificWebAnalyticEventTypeVersion", summary="Get a version of the report definition", description="Get a version of the web analytic event type by `Id`", responses={@ApiResponse(responseCode="200", description="WebAnalyticEvent", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEvent.class))}), @ApiResponse(responseCode="404", description="Web Analytic event type for instance {id} and version {version} is not found")})
    public WebAnalyticEvent getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the web analytic event", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Web Analytic Event type version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (WebAnalyticEvent)super.getVersionInternal(securityContext, id, version);
    }

    @PUT
    @Path(value="/collect")
    @Operation(operationId="addWebAnalyticEventData", summary="Add web analytic event data", description="Add web analytic event data", responses={@ApiResponse(responseCode="200", description="Successfully added web analytic event data", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEventData.class))})})
    public Response addReportResult(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid WebAnalyticEventData webAnalyticEventData) {
        return ((WebAnalyticEventRepository)this.repository).addWebAnalyticEventData(webAnalyticEventData);
    }

    @DELETE
    @Path(value="/{name}/{timestamp}/collect")
    @Operation(operationId="deleteWebAnalyticEventData", summary="Delete web analytic event data before a timestamp", description="Delete web analytic event data before a timestamp.", responses={@ApiResponse(responseCode="200", description="Successfully deleted Web Analytic Event Data")})
    public Response deleteWebAnalyticEventData(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Name of the Web Analytic event", schema=@Schema(implementation=WebAnalyticEventType.class)) @PathParam(value="name") WebAnalyticEventType name, @Parameter(description="Timestamp of the event. Event before the timestamp will be deleted", schema=@Schema(type="long")) @PathParam(value="timestamp") Long timestamp) {
        OperationContext operationContext = new OperationContext(this.entityType, MetadataOperation.DELETE);
        this.authorizer.authorize(securityContext, operationContext, this.getResourceContextByName(name.value()));
        ((WebAnalyticEventRepository)this.repository).deleteWebAnalyticEventData(name, timestamp);
        return Response.ok().build();
    }

    @GET
    @Path(value="/collect")
    @Operation(operationId="getWebAnalyticEventData", summary="Retrieve web analytic data", description="Retrieve web analytic data.", responses={@ApiResponse(responseCode="200", description="List of web analytic data", content={@Content(mediaType="application/json", schema=@Schema(implementation=WebAnalyticEventDataList.class))})})
    public ResultList<WebAnalyticEventData> listWebAnalyticEventData(@Context SecurityContext securityContext, @Parameter(description="Filter web analytic events for a particular event type", schema=@Schema(type="string")) @QueryParam(value="eventType") @NonNull String eventType, @Parameter(description="Filter web analytic events after the given start timestamp", schema=@Schema(type="number")) @QueryParam(value="startTs") @NonNull Long startTs, @Parameter(description="Filter web analytic events before the given end timestamp", schema=@Schema(type="number")) @QueryParam(value="endTs") @NonNull Long endTs) {
        if (eventType == null) {
            throw new NullPointerException("eventType is marked non-null but is null");
        }
        if (startTs == null) {
            throw new NullPointerException("startTs is marked non-null but is null");
        }
        if (endTs == null) {
            throw new NullPointerException("endTs is marked non-null but is null");
        }
        return ((WebAnalyticEventRepository)this.repository).getWebAnalyticEventData(eventType, startTs, endTs);
    }

    private WebAnalyticEvent getWebAnalyticEvent(CreateWebAnalyticEvent create, String user) {
        return this.copy(new WebAnalyticEvent(), (CreateEntity)create, user).withName(create.getName()).withDisplayName(create.getDisplayName()).withDescription(create.getDescription()).withEventType(create.getEventType());
    }

    public static class WebAnalyticEventDataList
    extends ResultList<WebAnalyticEventData> {
    }

    public static class WebAnalyticEventList
    extends ResultList<WebAnalyticEvent> {
    }
}

