/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search;

import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.search.SearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchIndexDefinition {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexDefinition.class);
    public static final String ENTITY_REPORT_DATA = "entityReportData";
    public static final String WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA = "webAnalyticEntityViewReportData";
    public static final String WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA = "webAnalyticUserActivityReportData";
    final EnumMap<ElasticSearchIndexType, ElasticSearchIndexStatus> elasticSearchIndexes = new EnumMap(ElasticSearchIndexType.class);
    public static final Map<String, Object> ENTITY_TO_MAPPING_SCHEMA_MAP = new HashMap<String, Object>();
    private final SearchClient searchClient;

    public SearchIndexDefinition(SearchClient client) {
        this.searchClient = client;
        for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
            this.elasticSearchIndexes.put(elasticSearchIndexType, ElasticSearchIndexStatus.NOT_CREATED);
        }
    }

    public void createIndexes(ElasticSearchConfiguration esConfig) {
        if (this.searchClient != null) {
            for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
                this.searchClient.createIndex(elasticSearchIndexType, esConfig.getSearchIndexMappingLanguage().value());
            }
        }
    }

    public void updateIndexes(ElasticSearchConfiguration esConfig) {
        if (this.searchClient != null) {
            for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
                this.searchClient.updateIndex(elasticSearchIndexType, esConfig.getSearchIndexMappingLanguage().value());
            }
        }
    }

    public void dropIndexes() {
        if (this.searchClient != null) {
            for (ElasticSearchIndexType elasticSearchIndexType : ElasticSearchIndexType.values()) {
                this.searchClient.deleteIndex(elasticSearchIndexType);
            }
        }
    }

    public static Map<String, Object> getIndexMappingSchema(Set<String> entities) {
        if (entities.contains("*")) {
            return ENTITY_TO_MAPPING_SCHEMA_MAP;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        entities.forEach(entityType -> result.put((String)entityType, ENTITY_TO_MAPPING_SCHEMA_MAP.get(entityType)));
        return result;
    }

    public static enum ElasticSearchIndexType {
        TABLE_SEARCH_INDEX("table", "table_search_index", "/elasticsearch/%s/table_index_mapping.json"),
        TOPIC_SEARCH_INDEX("topic", "topic_search_index", "/elasticsearch/%s/topic_index_mapping.json"),
        DASHBOARD_SEARCH_INDEX("dashboard", "dashboard_search_index", "/elasticsearch/%s/dashboard_index_mapping.json"),
        PIPELINE_SEARCH_INDEX("pipeline", "pipeline_search_index", "/elasticsearch/%s/pipeline_index_mapping.json"),
        USER_SEARCH_INDEX("user", "user_search_index", "/elasticsearch/%s/user_index_mapping.json"),
        TEAM_SEARCH_INDEX("team", "team_search_index", "/elasticsearch/%s/team_index_mapping.json"),
        GLOSSARY_SEARCH_INDEX("glossary", "glossary_search_index", "/elasticsearch/%s/glossary_index_mapping.json"),
        MLMODEL_SEARCH_INDEX("mlmodel", "mlmodel_search_index", "/elasticsearch/%s/mlmodel_index_mapping.json"),
        CONTAINER_SEARCH_INDEX("container", "container_search_index", "/elasticsearch/%s/container_index_mapping.json"),
        QUERY_SEARCH_INDEX("query", "query_search_index", "/elasticsearch/%s/query_index_mapping.json"),
        TAG_SEARCH_INDEX("tag", "tag_search_index", "/elasticsearch/%s/tag_index_mapping.json"),
        ENTITY_REPORT_DATA_INDEX("entityReportData", "entity_report_data_index", "/elasticsearch/entity_report_data_index.json"),
        TEST_CASE_SEARCH_INDEX("testCase", "test_case_search_index", "/elasticsearch/%s/test_case_index_mapping.json"),
        WEB_ANALYTIC_ENTITY_VIEW_REPORT_DATA_INDEX("webAnalyticEvent", "web_analytic_entity_view_report_data_index", "/elasticsearch/web_analytic_entity_view_report_data_index.json"),
        WEB_ANALYTIC_USER_ACTIVITY_REPORT_DATA_INDEX("webAnalyticUserActivityReportData", "web_analytic_user_activity_report_data_index", "/elasticsearch/web_analytic_user_activity_report_data_index.json");

        public final String indexName;
        public final String indexMappingFile;
        public final String entityType;

        private ElasticSearchIndexType(String entityType, String indexName, String indexMappingFile) {
            this.entityType = entityType;
            this.indexName = indexName;
            this.indexMappingFile = indexMappingFile;
        }
    }

    public static enum ElasticSearchIndexStatus {
        CREATED,
        NOT_CREATED,
        FAILED;

    }
}

