/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticSearch;

import java.util.List;
import java.util.Map;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.xcontent.XContentType;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.analytics.ReportData;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.ProcessorException;
import org.openmetadata.service.search.IndexUtil;
import org.openmetadata.service.search.SearchIndexDefinition;
import org.openmetadata.service.search.indexes.ReportDataIndexes;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchDataInsightProcessor
implements Processor<BulkRequest, ResultList<ReportData>> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchDataInsightProcessor.class);
    private final StepStats stats = new StepStats();

    @Override
    public BulkRequest process(ResultList<ReportData> input, Map<String, Object> contextData) throws ProcessorException {
        BulkRequest requests;
        String entityType = (String)contextData.get("entityType");
        if (CommonUtil.nullOrEmpty((String)entityType)) {
            throw new IllegalArgumentException("[EsDataInsightProcessor] entityType cannot be null or empty.");
        }
        LOG.debug("[EsDataInsightProcessor] Processing a Batch of Size: {}, EntityType: {} ", (Object)input.getData().size(), (Object)entityType);
        try {
            requests = this.buildBulkRequests(entityType, input.getData());
            LOG.debug("[EsDataInsightProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), input.getData().size(), 0});
            this.updateStats(input.getData().size(), 0);
        }
        catch (Exception e) {
            LOG.debug("[EsDataInsightProcessor] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{input.getData().size(), 0, input.getData().size()});
            this.updateStats(0, input.getData().size());
            throw new ProcessorException("[EsDataInsightProcessor] Batch encountered Exception. Failing Completely.", e);
        }
        return requests;
    }

    private BulkRequest buildBulkRequests(String entityType, List<ReportData> entities) {
        BulkRequest bulkRequests = new BulkRequest();
        for (ReportData reportData : entities) {
            UpdateRequest request = this.getUpdateRequest(entityType, reportData);
            bulkRequests.add(request);
        }
        return bulkRequests;
    }

    private UpdateRequest getUpdateRequest(String entityType, ReportData reportData) {
        SearchIndexDefinition.ElasticSearchIndexType indexType = IndexUtil.getIndexMappingByEntityType(entityType);
        UpdateRequest updateRequest = new UpdateRequest(indexType.indexName, reportData.getId().toString());
        updateRequest.doc(JsonUtils.pojoToJson(new ReportDataIndexes(reportData).buildESDoc()), XContentType.JSON);
        updateRequest.docAsUpsert(true);
        return updateRequest;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

