/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.PageViewsByEntities;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public class EsPageViewsByEntitiesAggregator
extends DataInsightAggregatorInterface {
    public EsPageViewsByEntitiesAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsEs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation entityTypeBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("entityType");
            for (MultiBucketsAggregation.Bucket entityTypeBucket : entityTypeBuckets.getBuckets()) {
                String entityType = entityTypeBucket.getKeyAsString();
                Sum sumPageViews = (Sum)entityTypeBucket.getAggregations().get("pageViews");
                data.add(new PageViewsByEntities().withEntityType(entityType).withTimestamp(timestamp).withPageViews(Double.valueOf(sumPageViews.getValue())));
            }
        }
        return data;
    }
}

