/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ColumnIndex;
import org.openmetadata.service.search.models.FlattenColumn;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class ContainerIndex
implements ColumnIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final Container container;

    public ContainerIndex(Container container) {
        this.container = container;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.container.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.container.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.container.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.container);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> columnSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        suggest.add(SearchSuggest.builder().input(this.container.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.container.getName()).weight(10).build());
        if (this.container.getDataModel() != null && this.container.getDataModel().getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.container.getDataModel().getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(SearchSuggest.builder().input(col.getName()).weight(5).build());
            }
        }
        serviceSuggest.add(SearchSuggest.builder().input(this.container.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("container", (EntityInterface)this.container));
        doc.put("displayName", this.container.getDisplayName() != null ? this.container.getDisplayName() : this.container.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.container.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("entityType", "container");
        doc.put("serviceType", this.container.getServiceType());
        return doc;
    }
}

