/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Dashboard;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ElasticSearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DashboardIndex
implements ElasticSearchIndex {
    final Dashboard dashboard;
    final List<String> excludeFields = List.of("changeDescription");

    public DashboardIndex(Dashboard dashboard) {
        this.dashboard = dashboard;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.dashboard.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.dashboard.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.dashboard.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.dashboard);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> chartSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> dataModelSuggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.dashboard.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.dashboard.getDisplayName()).weight(10).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.dashboard.getService().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("dashboard", (EntityInterface)this.dashboard));
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getCharts())) {
            chartSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        for (EntityReference chart : CommonUtil.listOrEmpty((List)this.dashboard.getDataModels())) {
            dataModelSuggest.add(SearchSuggest.builder().input(chart.getDisplayName()).weight(5).build());
        }
        doc.put("name", this.dashboard.getDisplayName());
        doc.put("displayName", this.dashboard.getDisplayName() != null ? this.dashboard.getDisplayName() : this.dashboard.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.dashboard.getFollowers()));
        doc.put("tier", parseTags.getTierTag());
        doc.put("suggest", suggest);
        doc.put("chart_suggest", chartSuggest);
        doc.put("data_model_suggest", dataModelSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "dashboard");
        doc.put("serviceType", this.dashboard.getServiceType());
        return doc;
    }
}

