/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ElasticSearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class GlossaryTermIndex
implements ElasticSearchIndex {
    final GlossaryTerm glossaryTerm;
    final List<String> excludeFields = List.of("changeDescription");

    public GlossaryTermIndex(GlossaryTerm glossaryTerm) {
        this.glossaryTerm = glossaryTerm;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.glossaryTerm.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.glossaryTerm.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.glossaryTerm.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.glossaryTerm);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getDisplayName()).weight(10).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "glossaryTerm");
        return doc;
    }
}

