/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.teams.User;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ElasticSearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class UserIndex
implements ElasticSearchIndex {
    final User user;
    final List<String> excludeFields = List.of("owns", "changeDescription", "follows", "authenticationMechanism");

    public UserIndex(User user) {
        this.user = user;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (CommonUtil.nullOrEmpty((String)this.user.getDisplayName())) {
            this.user.setDisplayName(this.user.getName());
        }
        if (this.user.getIsBot() == null) {
            this.user.setIsBot(Boolean.valueOf(false));
        }
        Map<String, Object> doc = JsonUtils.getMap(this.user);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.user.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.user.getDisplayName()).weight(10).build());
        doc.put("suggest", suggest);
        doc.put("entityType", "user");
        return doc;
    }
}

