/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.openSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithOwner;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.opensearch.search.aggregations.metrics.Sum;

public class OsServicesOwnerAggregator
extends DataInsightAggregatorInterface {
    protected OsServicesOwnerAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsOs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation servicesBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("serviceName");
            for (MultiBucketsAggregation.Bucket serviceBucket : servicesBuckets.getBuckets()) {
                String serviceName = serviceBucket.getKeyAsString();
                Sum sumHasOwner = (Sum)serviceBucket.getAggregations().get("hasOwnerFraction");
                Sum sumEntityCount = (Sum)serviceBucket.getAggregations().get("entityCount");
                data.add(new PercentageOfServicesWithOwner().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount(Double.valueOf(sumEntityCount.getValue())).withHasOwner(Double.valueOf(sumHasOwner.getValue())).withHasOwnerFraction(Double.valueOf(sumHasOwner.getValue() / sumEntityCount.getValue())));
            }
        }
        return data;
    }
}

