/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security.policyevaluator;

import com.google.common.annotations.VisibleForTesting;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import lombok.NonNull;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.util.EntityUtil;

public class ResourceContext<T extends EntityInterface>
implements ResourceContextInterface {
    @NonNull
    private final String resource;
    private final EntityRepository<T> entityRepository;
    private final UUID id;
    private final String name;
    private T entity;

    public ResourceContext(String resource) {
        this.resource = resource;
        this.id = null;
        this.name = null;
        this.entityRepository = Entity.getEntityRepository(resource);
    }

    public ResourceContext(String resource, UUID id, String name) {
        this.resource = resource;
        this.id = id;
        this.name = name;
        this.entityRepository = Entity.getEntityRepository(resource);
    }

    @VisibleForTesting
    public ResourceContext(String resource, T entity, EntityRepository<T> repository) {
        this.resource = resource;
        this.id = null;
        this.name = null;
        this.entity = entity;
        this.entityRepository = repository;
    }

    @Override
    public EntityReference getOwner() {
        this.resolveEntity();
        if (this.entity == null) {
            return null;
        }
        if ("user".equals(this.entityRepository.getEntityType())) {
            return this.entity.getEntityReference();
        }
        return this.entity.getOwner();
    }

    @Override
    public List<TagLabel> getTags() {
        this.resolveEntity();
        return this.entity == null ? Collections.emptyList() : Entity.getEntityTags(this.getResource(), this.entity);
    }

    @Override
    public EntityInterface getEntity() {
        return this.resolveEntity();
    }

    private EntityInterface resolveEntity() {
        if (this.entity == null) {
            String fields = "";
            if (this.entityRepository.isSupportsOwner()) {
                fields = EntityUtil.addField(fields, "owner");
            }
            if (this.entityRepository.isSupportsTags()) {
                fields = EntityUtil.addField(fields, "tags");
            }
            EntityUtil.Fields fieldList = this.entityRepository.getFields(fields);
            try {
                if (this.id != null) {
                    this.entity = this.entityRepository.get(null, this.id, fieldList, Include.NON_DELETED, true);
                } else if (this.name != null) {
                    this.entity = this.entityRepository.getByName(null, this.name, fieldList, Include.NON_DELETED, true);
                }
            }
            catch (EntityNotFoundException e) {
                this.entity = null;
            }
        }
        return this.entity;
    }

    @Override
    @NonNull
    public String getResource() {
        return this.resource;
    }
}

