/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.ws.rs.core.UriInfo;
import lombok.NonNull;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.ResourceRegistry;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Entity {
    private static final Logger LOG = LoggerFactory.getLogger(Entity.class);
    public static final String SEPARATOR = ".";
    private static final Map<String, EntityRepository<? extends EntityInterface>> ENTITY_REPOSITORY_MAP = new HashMap<String, EntityRepository<? extends EntityInterface>>();
    private static FeedRepository feedRepository;
    private static final List<String> ENTITY_LIST;
    public static final String FIELD_OWNER = "owner";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_DESCRIPTION = "description";
    public static final String FIELD_FOLLOWERS = "followers";
    public static final String FIELD_VOTES = "votes";
    public static final String FIELD_TAGS = "tags";
    public static final String FIELD_DELETED = "deleted";
    public static final String FIELD_PIPELINE_STATUS = "pipelineStatus";
    public static final String FIELD_DISPLAY_NAME = "displayName";
    public static final String FIELD_EXTENSION = "extension";
    public static final String FIELD_USAGE_SUMMARY = "usageSummary";
    public static final String FIELD_REVIEWERS = "reviewers";
    public static final String DATABASE_SERVICE = "databaseService";
    public static final String MESSAGING_SERVICE = "messagingService";
    public static final String DASHBOARD_SERVICE = "dashboardService";
    public static final String PIPELINE_SERVICE = "pipelineService";
    public static final String STORAGE_SERVICE = "storageService";
    public static final String MLMODEL_SERVICE = "mlmodelService";
    public static final String METADATA_SERVICE = "metadataService";
    public static final String TABLE = "table";
    public static final String DATABASE = "database";
    public static final String DATABASE_SCHEMA = "databaseSchema";
    public static final String METRICS = "metrics";
    public static final String DASHBOARD = "dashboard";
    public static final String DASHBOARD_DATA_MODEL = "dashboardDataModel";
    public static final String PIPELINE = "pipeline";
    public static final String CHART = "chart";
    public static final String REPORT = "report";
    public static final String TOPIC = "topic";
    public static final String MLMODEL = "mlmodel";
    public static final String CONTAINER = "container";
    public static final String QUERY = "query";
    public static final String GLOSSARY = "glossary";
    public static final String GLOSSARY_TERM = "glossaryTerm";
    public static final String TAG = "tag";
    public static final String CLASSIFICATION = "classification";
    public static final String TYPE = "type";
    public static final String TEST_DEFINITION = "testDefinition";
    public static final String TEST_CONNECTION_DEFINITION = "testConnectionDefinition";
    public static final String TEST_SUITE = "testSuite";
    public static final String KPI = "kpi";
    public static final String TEST_CASE = "testCase";
    public static final String WEB_ANALYTIC_EVENT = "webAnalyticEvent";
    public static final String DATA_INSIGHT_CHART = "dataInsightChart";
    public static final String POLICY = "policy";
    public static final String POLICIES = "policies";
    public static final String ROLE = "role";
    public static final String USER = "user";
    public static final String TEAM = "team";
    public static final String BOT = "bot";
    public static final String INGESTION_PIPELINE = "ingestionPipeline";
    public static final String EVENT_SUBSCRIPTION = "eventsubscription";
    public static final String THREAD = "THREAD";
    public static final String WORKFLOW = "workflow";
    public static final String ADMIN_USER_NAME = "admin";
    public static final String ORGANIZATION_NAME = "Organization";
    public static final String ORGANIZATION_POLICY_NAME = "OrganizationPolicy";
    public static final String INGESTION_BOT_NAME = "ingestion-bot";
    public static final String INGESTION_BOT_ROLE = "IngestionBotRole";
    public static final String PROFILER_BOT_NAME = "profiler-bot";
    public static final String PROFILER_BOT_ROLE = "ProfilerBotRole";
    public static final String QUALITY_BOT_NAME = "quality-bot";
    public static final String QUALITY_BOT_ROLE = "QualityBotRole";
    public static final String ALL_RESOURCES = "All";
    static final Map<ServiceType, String> SERVICE_TYPE_ENTITY_MAP;
    public static final List<String> ACTIVITY_FEED_EXCLUDED_ENTITIES;

    private Entity() {
    }

    public static <T extends EntityInterface> void registerEntity(Class<T> clazz, String entity, EntityRepository<T> entityRepository, List<MetadataOperation> entitySpecificOperations) {
        ENTITY_REPOSITORY_MAP.put(entity, entityRepository);
        EntityInterface.CANONICAL_ENTITY_NAME_MAP.put(entity.toLowerCase(Locale.ROOT), entity);
        EntityInterface.ENTITY_TYPE_TO_CLASS_MAP.put(entity.toLowerCase(Locale.ROOT), clazz);
        ENTITY_LIST.add(entity);
        Collections.sort(ENTITY_LIST);
        ResourceRegistry.addResource(entity, entitySpecificOperations, Entity.getEntityFields(clazz));
        LOG.info("Registering entity {} {}", clazz, (Object)entity);
    }

    public static List<String> getEntityList() {
        return Collections.unmodifiableList(ENTITY_LIST);
    }

    public static EntityReference getEntityReference(EntityReference ref, Include include) {
        if (ref == null) {
            return null;
        }
        return ref.getId() != null ? Entity.getEntityReferenceById(ref.getType(), ref.getId(), include) : Entity.getEntityReferenceByName(ref.getType(), ref.getFullyQualifiedName(), include);
    }

    public static EntityReference getEntityReferenceById(@NonNull String entityType, @NonNull UUID id, Include include) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
        include = repository.supportsSoftDelete ? Include.ALL : include;
        return repository.getReference(id, include);
    }

    public static EntityReference getEntityReferenceByName(@NonNull String entityType, String fqn, Include include) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        if (fqn == null) {
            return null;
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(entityType);
        return repository.getReferenceByName(fqn, include);
    }

    public static EntityReference getOwner(@NonNull EntityReference reference) {
        if (reference == null) {
            throw new NullPointerException("reference is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> repository = Entity.getEntityRepository(reference.getType());
        return repository.getOwner(reference);
    }

    public static void withHref(UriInfo uriInfo, List<EntityReference> list) {
        CommonUtil.listOrEmpty(list).forEach(ref -> Entity.withHref(uriInfo, ref));
    }

    public static void withHref(UriInfo uriInfo, EntityReference ref) {
        if (ref == null) {
            return;
        }
        String entityType = ref.getType();
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        URI href = entityRepository.getHref(uriInfo, ref.getId());
        ref.withHref(href);
    }

    public static boolean shouldDisplayEntityChangeOnFeed(@NonNull String entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        return !ACTIVITY_FEED_EXCLUDED_ENTITIES.contains(entityType);
    }

    public static EntityUtil.Fields getFields(String entityType, List<String> fields) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        return entityRepository.getFields(String.join((CharSequence)",", fields));
    }

    public static <T> T getEntity(EntityReference ref, String fields, Include include) {
        return ref.getId() != null ? Entity.getEntity(ref.getType(), ref.getId(), fields, include) : Entity.getEntityByName(ref.getType(), ref.getFullyQualifiedName(), fields, include);
    }

    public static <T> T getEntity(MessageParser.EntityLink link, String fields, Include include) {
        return Entity.getEntityByName(link.getEntityType(), link.getEntityFQN(), fields, include);
    }

    public static <T> T getEntity(String entityType, UUID id, String fields, Include include, boolean fromCache) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        EntityInterface entity = entityRepository.get(null, id, entityRepository.getFields(fields), include, fromCache);
        return (T)entity;
    }

    public static <T> T getEntity(String entityType, UUID id, String fields, Include include) {
        return Entity.getEntity(entityType, id, fields, include, true);
    }

    public static <T> T getEntityByName(String entityType, String fqn, String fields, Include include, boolean fromCache) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        EntityInterface entity = entityRepository.getByName(null, fqn, entityRepository.getFields(fields), include, fromCache);
        return (T)entity;
    }

    public static <T> T getEntityByName(String entityType, String fqn, String fields, Include include) {
        return Entity.getEntityByName(entityType, fqn, fields, include, true);
    }

    public static EntityRepository<? extends EntityInterface> getEntityRepository(@NonNull String entityType) {
        if (entityType == null) {
            throw new NullPointerException("entityType is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> entityRepository = ENTITY_REPOSITORY_MAP.get(entityType);
        if (entityRepository == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityTypeNotFound(entityType));
        }
        return entityRepository;
    }

    public static EntityRepository<? extends EntityInterface> getServiceEntityRepository(@NonNull ServiceType serviceType) {
        if (serviceType == null) {
            throw new NullPointerException("serviceType is marked non-null but is null");
        }
        EntityRepository<? extends EntityInterface> entityRepository = ENTITY_REPOSITORY_MAP.get(SERVICE_TYPE_ENTITY_MAP.get(serviceType));
        if (entityRepository == null) {
            throw EntityNotFoundException.byMessage(CatalogExceptionMessage.entityTypeNotFound(serviceType.value()));
        }
        return entityRepository;
    }

    public static List<TagLabel> getEntityTags(String entityType, EntityInterface entity) {
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(entityType);
        return CommonUtil.listOrEmpty(entityRepository.getAllTags(entity));
    }

    public static void deleteEntity(String updatedBy, String entityType, UUID entityId, boolean recursive, boolean hardDelete) {
        EntityRepository<? extends EntityInterface> dao = Entity.getEntityRepository(entityType);
        dao.delete(updatedBy, (EntityInterface)entityId, recursive, hardDelete);
    }

    public static void restoreEntity(String updatedBy, String entityType, UUID entityId) {
        EntityRepository<? extends EntityInterface> dao = Entity.getEntityRepository(entityType);
        dao.restoreEntity(updatedBy, entityType, entityId);
    }

    public static <T> String getEntityTypeFromClass(Class<T> clz) {
        return (String)EntityInterface.CANONICAL_ENTITY_NAME_MAP.get(clz.getSimpleName().toLowerCase(Locale.ROOT));
    }

    public static String getEntityTypeFromObject(Object object) {
        return (String)EntityInterface.CANONICAL_ENTITY_NAME_MAP.get(object.getClass().getSimpleName().toLowerCase(Locale.ROOT));
    }

    public static Class<? extends EntityInterface> getEntityClassFromType(String entityType) {
        return (Class)EntityInterface.ENTITY_TYPE_TO_CLASS_MAP.get(entityType.toLowerCase(Locale.ROOT));
    }

    public static <T> Set<String> getEntityFields(Class<T> clz) {
        JsonPropertyOrder propertyOrder = clz.getAnnotation(JsonPropertyOrder.class);
        return new HashSet<String>(Arrays.asList(propertyOrder.value()));
    }

    public static boolean supportsFeed(String entityType) {
        return CommonUtil.listOf((Object[])new String[]{TABLE, DATABASE, DATABASE_SCHEMA, METRICS, DASHBOARD, DASHBOARD_DATA_MODEL, PIPELINE, CHART, REPORT, TOPIC, MLMODEL, CONTAINER, QUERY, GLOSSARY, GLOSSARY_TERM, TAG, CLASSIFICATION}).contains(entityType);
    }

    public static FeedRepository getFeedRepository() {
        return feedRepository;
    }

    public static void setFeedRepository(FeedRepository feedRepository) {
        Entity.feedRepository = feedRepository;
    }

    static {
        ENTITY_LIST = new ArrayList<String>();
        SERVICE_TYPE_ENTITY_MAP = new EnumMap<ServiceType, String>(ServiceType.class);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.DATABASE, DATABASE_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.MESSAGING, MESSAGING_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.DASHBOARD, DASHBOARD_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.PIPELINE, PIPELINE_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.ML_MODEL, MLMODEL_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.METADATA, METADATA_SERVICE);
        SERVICE_TYPE_ENTITY_MAP.put(ServiceType.STORAGE, STORAGE_SERVICE);
        ACTIVITY_FEED_EXCLUDED_ENTITIES = List.of(USER, TEAM, ROLE, POLICY, BOT, INGESTION_PIPELINE, DATABASE_SERVICE, PIPELINE_SERVICE, DASHBOARD_SERVICE, MESSAGING_SERVICE, WORKFLOW, TEST_SUITE);
    }

    public static class EntityList {
        private EntityList() {
        }

        public static List<String> getEntityList(String name, String entitiesParam) {
            if (entitiesParam == null) {
                return Collections.emptyList();
            }
            if ((entitiesParam = entitiesParam.replace(" ", "")).equals("*")) {
                return List.of("*");
            }
            List<String> list = Arrays.asList(entitiesParam.split(","));
            EntityList.validateEntities(name, list);
            return list;
        }

        private static void validateEntities(String name, List<String> list) {
            for (String entity : list) {
                if (ENTITY_REPOSITORY_MAP.get(entity) != null) continue;
                throw new IllegalArgumentException(String.format("Invalid entity %s in query param %s", entity, name));
            }
        }
    }
}

