/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.events.subscription;

import com.lmax.disruptor.BatchEventProcessor;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openmetadata.schema.entity.events.EventSubscription;
import org.openmetadata.schema.entity.events.SubscriptionStatus;
import org.openmetadata.service.events.EventPubSub;
import org.openmetadata.service.events.errors.EventPublisherException;
import org.openmetadata.service.events.subscription.AbstractAlertPublisher;
import org.openmetadata.service.events.subscription.AlertUtil;
import org.openmetadata.service.resources.events.EventResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPublisher
extends AbstractAlertPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionPublisher.class);
    private final CountDownLatch shutdownLatch = new CountDownLatch(1);
    private BatchEventProcessor<EventPubSub.ChangeEventHolder> processor;

    public SubscriptionPublisher(EventSubscription eventSub) {
        super(eventSub);
    }

    public void onStart() {
        this.setSuccessStatus(System.currentTimeMillis());
        this.onStartDelegate();
        LOG.info("Alert-lifecycle-onStart {}", (Object)this.eventSubscription.getName());
    }

    public void onShutdown() {
        this.currentBackoffTime = 0;
        this.shutdownLatch.countDown();
        this.onShutdownDelegate();
        LOG.info("Alert-lifecycle-onShutdown {}", (Object)this.eventSubscription.getName());
    }

    public synchronized EventSubscription getEventSubscription() {
        return this.eventSubscription;
    }

    public synchronized void setErrorStatus(Long attemptTime, Integer statusCode, String reason) {
        this.setStatus(SubscriptionStatus.Status.FAILED, attemptTime, statusCode, reason, null);
    }

    public synchronized void setAwaitingRetry(Long attemptTime, int statusCode, String reason) {
        this.setStatus(SubscriptionStatus.Status.AWAITING_RETRY, attemptTime, statusCode, reason, attemptTime + (long)this.currentBackoffTime);
    }

    public synchronized SubscriptionStatus setSuccessStatus(Long updateTime) {
        SubscriptionStatus subStatus = AlertUtil.buildSubscriptionStatus(SubscriptionStatus.Status.ACTIVE, updateTime, null, null, null, updateTime, updateTime);
        this.eventSubscription.setStatusDetails(subStatus);
        return subStatus;
    }

    protected synchronized SubscriptionStatus setStatus(SubscriptionStatus.Status status, Long attemptTime, Integer statusCode, String reason, Long timestamp) {
        SubscriptionStatus subStatus = AlertUtil.buildSubscriptionStatus(status, null, attemptTime, statusCode, reason, timestamp, attemptTime);
        this.eventSubscription.setStatusDetails(subStatus);
        return subStatus;
    }

    public void awaitShutdown() throws InterruptedException {
        LOG.info("Awaiting shutdown alertActionPublisher-lifecycle {}", (Object)this.eventSubscription.getName());
        this.shutdownLatch.await(5L, TimeUnit.SECONDS);
    }

    public void setProcessor(BatchEventProcessor<EventPubSub.ChangeEventHolder> processor) {
        this.processor = processor;
    }

    protected void sendAlert(EventResource.EventList list) throws InterruptedException {
    }

    protected void onStartDelegate() {
    }

    protected void onShutdownDelegate() {
    }

    public int getCurrentBackOff() {
        return this.currentBackoffTime;
    }

    @Override
    public void publish(EventResource.EventList list) throws EventPublisherException {
        try {
            LOG.info("Sending Alert {}:{}:{}", new Object[]{this.eventSubscription.getName(), this.eventSubscription.getStatusDetails().getStatus(), this.batch.size()});
            this.sendAlert(list);
        }
        catch (Exception ex) {
            LOG.warn("Invalid Exception in Alert {}", (Object)this.eventSubscription.getName());
        }
    }

    public BatchEventProcessor<EventPubSub.ChangeEventHolder> getProcessor() {
        return this.processor;
    }
}

