/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.factory;

import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.DefaultEntityFormatter;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.entity.IngestionPipelineFormatter;
import org.openmetadata.service.formatter.entity.KpiFormatter;
import org.openmetadata.service.formatter.entity.QueryFormatter;
import org.openmetadata.service.formatter.entity.TestCaseFormatter;
import org.openmetadata.service.formatter.field.DefaultFieldFormatter;
import org.openmetadata.service.formatter.field.FollowersFormatter;
import org.openmetadata.service.formatter.field.OwnerFormatter;
import org.openmetadata.service.formatter.field.TagFormatter;
import org.openmetadata.service.resources.feeds.MessageParser;

public final class ParserFactory {
    private ParserFactory() {
    }

    public static EntityFormatter getEntityParser(String entityType) {
        switch (entityType) {
            case "query": {
                return new QueryFormatter();
            }
            case "testCase": {
                return new TestCaseFormatter();
            }
            case "kpi": {
                return new KpiFormatter();
            }
            case "ingestionPipeline": {
                return new IngestionPipelineFormatter();
            }
        }
        return new DefaultEntityFormatter();
    }

    public static DefaultFieldFormatter getFieldParserObject(MessageDecorator<?> decorator, String fieldOldValue, String fieldNewValue, String fieldChangeName, MessageParser.EntityLink entityLink) {
        switch (fieldChangeName) {
            case "tags": {
                return new TagFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            }
            case "followers": {
                return new FollowersFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            }
            case "owner": {
                return new OwnerFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
            }
        }
        return new DefaultFieldFormatter(decorator, fieldOldValue, fieldNewValue, fieldChangeName, entityLink);
    }
}

