/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.UUID;
import org.openmetadata.schema.ServiceConnectionEntityInterface;
import org.openmetadata.schema.ServiceEntityInterface;
import org.openmetadata.schema.entity.services.ServiceType;
import org.openmetadata.schema.entity.services.connections.TestConnectionResult;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.secrets.SecretsManager;
import org.openmetadata.service.secrets.SecretsManagerFactory;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.JsonUtils;

public abstract class ServiceEntityRepository<T extends ServiceEntityInterface, S extends ServiceConnectionEntityInterface>
extends EntityRepository<T> {
    private final Class<S> serviceConnectionClass;
    private final ServiceType serviceType;

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, Class<S> serviceConnectionClass, ServiceType serviceType) {
        this(collectionPath, service, dao, entityDAO, serviceConnectionClass, "", serviceType);
        this.quoteFqn = true;
    }

    protected ServiceEntityRepository(String collectionPath, String service, CollectionDAO dao, EntityDAO<T> entityDAO, Class<S> serviceConnectionClass, String updatedFields, ServiceType serviceType) {
        super(collectionPath, service, entityDAO.getEntityClass(), entityDAO, dao, "", updatedFields);
        this.serviceConnectionClass = serviceConnectionClass;
        this.serviceType = serviceType;
    }

    @Override
    public T setFields(T entity, EntityUtil.Fields fields) {
        entity.setPipelines(fields.contains("pipelines") ? this.getIngestionPipelines(entity) : null);
        return entity;
    }

    @Override
    public T clearFields(T entity, EntityUtil.Fields fields) {
        if (!fields.contains("pipelines")) {
            entity.setPipelines(null);
        }
        return entity;
    }

    @Override
    public void prepare(T service) {
        service.getConnection().setConfig(SecretsManagerFactory.getSecretsManager().encryptServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), this.serviceType));
    }

    @Override
    public void storeEntity(T service, boolean update) {
        this.store(service, update);
    }

    @Override
    public void storeRelationships(T service) {
    }

    public T addTestConnectionResult(UUID serviceId, TestConnectionResult testConnectionResult) {
        ServiceEntityInterface service = (ServiceEntityInterface)this.dao.findEntityById(serviceId);
        service.setTestConnectionResult(testConnectionResult);
        this.dao.update(serviceId, service.getFullyQualifiedName(), JsonUtils.pojoToJson(service));
        return (T)service;
    }

    @Override
    protected void postDelete(T service) {
        SecretsManagerFactory.getSecretsManager().deleteSecretsFromServiceConnectionConfig(service.getConnection().getConfig(), service.getServiceType().value(), service.getName(), this.serviceType);
    }

    @Override
    public ServiceUpdater getUpdater(T original, T updated, EntityRepository.Operation operation) {
        return new ServiceUpdater(this, original, updated, operation);
    }

    public Class<S> getServiceConnectionClass() {
        return this.serviceConnectionClass;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public static class ServiceUpdater
    extends EntityRepository.EntityUpdater {
        final /* synthetic */ ServiceEntityRepository this$0;

        public ServiceUpdater(T original, T updated, EntityRepository.Operation operation) {
            this.this$0 = this$0;
            super((EntityRepository)this$0, original, updated, operation);
        }

        @Override
        public void entitySpecificUpdate() {
            this.updateConnection();
        }

        private void updateConnection() {
            ServiceConnectionEntityInterface origConn = ((ServiceEntityInterface)this.original).getConnection();
            ServiceConnectionEntityInterface updatedConn = ((ServiceEntityInterface)this.updated).getConnection();
            String origJson = JsonUtils.pojoToJson(origConn);
            String updatedJson = JsonUtils.pojoToJson(updatedConn);
            ServiceConnectionEntityInterface decryptedOrigConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(origJson, this.this$0.serviceConnectionClass);
            ServiceConnectionEntityInterface decryptedUpdatedConn = (ServiceConnectionEntityInterface)JsonUtils.readValue(updatedJson, this.this$0.serviceConnectionClass);
            SecretsManager secretsManager = SecretsManagerFactory.getSecretsManager();
            decryptedOrigConn.setConfig(secretsManager.decryptServiceConnectionConfig(decryptedOrigConn.getConfig(), ((ServiceEntityInterface)this.original).getServiceType().value(), this.this$0.serviceType));
            decryptedUpdatedConn.setConfig(secretsManager.decryptServiceConnectionConfig(decryptedUpdatedConn.getConfig(), ((ServiceEntityInterface)this.updated).getServiceType().value(), this.this$0.serviceType));
            if (!EntityUtil.objectMatch.test(decryptedOrigConn, decryptedUpdatedConn)) {
                this.recordChange("connection", "old-encrypted-value", "new-encrypted-value", true);
            }
        }
    }
}

