/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.postgres.v111;

import org.jdbi.v3.core.Handle;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.migration.api.MigrationProcessImpl;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.migration.utils.v111.MigrationUtilV111;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Migration
extends MigrationProcessImpl {
    private static final Logger LOG = LoggerFactory.getLogger(Migration.class);
    private CollectionDAO collectionDAO;
    private Handle handle;

    public Migration(MigrationFile migrationFile) {
        super(migrationFile);
    }

    @Override
    public void initialize(Handle handle) {
        super.initialize(handle);
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
    }

    @Override
    public void runDataMigration() {
        String getSql = "SELECT t1.id AS id1, t2.id AS id2 FROM test_suite t1 JOIN test_suite t2 ON t1.json -> 'executableEntityReference' -> 'fullyQualifiedName' = t2.json -> 'executableEntityReference' -> 'fullyQualifiedName' AND t1.id != t2.id;";
        MigrationUtilV111.removeDuplicateTestCases(this.collectionDAO, this.handle, getSql);
        String updateSql = "UPDATE test_suite SET json = :json::jsonb, fqnHash = :fqnHash WHERE id = :id;";
        String resultListSql = "SELECT json FROM test_suite WHERE json -> 'executable' = 'true'";
        MigrationUtilV111.runTestSuiteMigration(this.collectionDAO, this.handle, getSql, updateSql, resultListSql);
    }
}

