/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticSearch;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithDescription;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public class EsServicesDescriptionAggregator
extends DataInsightAggregatorInterface {
    protected EsServicesDescriptionAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() throws ParseException {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        Histogram timestampBuckets = (Histogram)this.aggregationsEs.get("timestamp");
        ArrayList<Object> data = new ArrayList<Object>();
        for (Histogram.Bucket timestampBucket : timestampBuckets.getBuckets()) {
            String dateTimeString = timestampBucket.getKeyAsString();
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            MultiBucketsAggregation servicesBuckets = (MultiBucketsAggregation)timestampBucket.getAggregations().get("serviceName");
            for (MultiBucketsAggregation.Bucket servicesBucket : servicesBuckets.getBuckets()) {
                String serviceName = servicesBucket.getKeyAsString();
                Sum sumCompletedDescriptions = (Sum)servicesBucket.getAggregations().get("completedDescriptionFraction");
                Sum sumEntityCount = (Sum)servicesBucket.getAggregations().get("entityCount");
                data.add(new PercentageOfServicesWithDescription().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount(Double.valueOf(sumEntityCount.getValue())).withCompletedDescription(Double.valueOf(sumCompletedDescriptions.getValue())).withCompletedDescriptionFraction(Double.valueOf(sumCompletedDescriptions.getValue() / sumEntityCount.getValue())));
            }
        }
        return data;
    }
}

