/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.MlModel;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ElasticSearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class MlModelIndex
implements ElasticSearchIndex {
    final MlModel mlModel;
    final List<String> excludeFields = List.of("changeDescription");

    public MlModelIndex(MlModel mlModel) {
        this.mlModel = mlModel;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.mlModel.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.mlModel.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.mlModel.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.mlModel);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        suggest.add(SearchSuggest.builder().input(this.mlModel.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.mlModel.getName()).weight(10).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("mlmodel", (EntityInterface)this.mlModel));
        doc.put("displayName", this.mlModel.getDisplayName() != null ? this.mlModel.getDisplayName() : this.mlModel.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.mlModel.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("entityType", "mlmodel");
        doc.put("serviceType", this.mlModel.getServiceType());
        return doc;
    }
}

