/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Table;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.ColumnIndex;
import org.openmetadata.service.search.models.FlattenColumn;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class TableIndex
implements ColumnIndex {
    private static final List<String> excludeFields = List.of("sampleData", "tableProfile", "joins", "changeDescription", "viewDefinition, tableProfilerConfig, profile, location, tableQueries, tests, dataModel");
    final Table table;

    public TableIndex(Table table) {
        this.table = table;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        if (this.table.getOwner() != null) {
            EntityReference owner;
            owner.setDisplayName(CommonUtil.nullOrEmpty((String)(owner = this.table.getOwner()).getDisplayName()) ? owner.getName() : owner.getDisplayName());
            this.table.setOwner(owner);
        }
        Map<String, Object> doc = JsonUtils.getMap(this.table);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> columnSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> schemaSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> databaseSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        if (this.table.getColumns() != null) {
            ArrayList<FlattenColumn> cols = new ArrayList<FlattenColumn>();
            this.parseColumns(this.table.getColumns(), cols, null);
            for (FlattenColumn col : cols) {
                columnSuggest.add(SearchSuggest.builder().input(col.getName()).weight(5).build());
            }
        }
        this.parseTableSuggest(suggest);
        serviceSuggest.add(SearchSuggest.builder().input(this.table.getService().getName()).weight(5).build());
        databaseSuggest.add(SearchSuggest.builder().input(this.table.getDatabase().getName()).weight(5).build());
        schemaSuggest.add(SearchSuggest.builder().input(this.table.getDatabaseSchema().getName()).weight(5).build());
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("table", (EntityInterface)this.table));
        doc.put("displayName", this.table.getDisplayName() != null ? this.table.getDisplayName() : this.table.getName());
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.table.getFollowers()));
        doc.put("suggest", suggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("column_suggest", columnSuggest);
        doc.put("schema_suggest", schemaSuggest);
        doc.put("database_suggest", databaseSuggest);
        doc.put("entityType", "table");
        doc.put("serviceType", this.table.getServiceType());
        return doc;
    }

    private void parseTableSuggest(List<SearchSuggest> suggest) {
        suggest.add(SearchSuggest.builder().input(this.table.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.table.getName()).weight(10).build());
        String[] fqnPartsWithoutService = this.table.getFullyQualifiedName().split(Pattern.quote("."), 2);
        if (fqnPartsWithoutService.length == 2) {
            suggest.add(SearchSuggest.builder().input(fqnPartsWithoutService[1]).weight(5).build());
            String[] fqnPartsWithoutDB = fqnPartsWithoutService[1].split(Pattern.quote("."), 2);
            if (fqnPartsWithoutDB.length == 2) {
                suggest.add(SearchSuggest.builder().input(fqnPartsWithoutDB[1]).weight(5).build());
            }
        }
    }
}

