/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.openSearch;

import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.MostActiveUsers;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.opensearch.search.aggregations.Aggregations;
import org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.opensearch.search.aggregations.metrics.Max;
import org.opensearch.search.aggregations.metrics.Sum;

public class OsMostActiveUsersAggregator
extends DataInsightAggregatorInterface {
    public OsMostActiveUsersAggregator(Aggregations aggregations, DataInsightChartResult.DataInsightChartType dataInsightChartType) {
        super(aggregations, dataInsightChartType);
    }

    @Override
    public DataInsightChartResult process() {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(this.dataInsightChartType);
    }

    @Override
    public List<Object> aggregate() {
        MultiBucketsAggregation userNameBuckets = (MultiBucketsAggregation)this.aggregationsOs.get("userName");
        ArrayList<Object> data = new ArrayList<Object>();
        for (MultiBucketsAggregation.Bucket userNameBucket : userNameBuckets.getBuckets()) {
            String userName = userNameBucket.getKeyAsString();
            Sum sumSession = (Sum)userNameBucket.getAggregations().get("sessions");
            Sum sumPageViews = (Sum)userNameBucket.getAggregations().get("pageViews");
            Sum sumSessionDuration = (Sum)userNameBucket.getAggregations().get("sessionDuration");
            Max lastSession = (Max)userNameBucket.getAggregations().get("lastSession");
            MultiBucketsAggregation teamBucket = (MultiBucketsAggregation)userNameBucket.getAggregations().get("team");
            String team = null;
            if (!teamBucket.getBuckets().isEmpty()) {
                team = ((MultiBucketsAggregation.Bucket)teamBucket.getBuckets().get(0)).getKeyAsString();
            }
            data.add(new MostActiveUsers().withUserName(userName).withLastSession(Long.valueOf((long)lastSession.getValue())).withPageViews(Double.valueOf(sumPageViews.getValue())).withSessionDuration(Double.valueOf(sumSessionDuration.getValue())).withSessions(Double.valueOf(sumSession.getValue())).withTeam(team).withAvgSessionDuration(Double.valueOf(sumSessionDuration.getValue() / sumSession.getValue())));
        }
        return data;
    }
}

