/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.security;

import java.util.List;
import javax.ws.rs.core.SecurityContext;
import org.jdbi.v3.core.Jdbi;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Permission;
import org.openmetadata.schema.type.ResourcePermission;
import org.openmetadata.service.OpenMetadataApplicationConfig;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.security.SecurityUtil;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.security.policyevaluator.PolicyEvaluator;
import org.openmetadata.service.security.policyevaluator.ResourceContextInterface;
import org.openmetadata.service.security.policyevaluator.SubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizer
implements Authorizer {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultAuthorizer.class);

    @Override
    public void init(OpenMetadataApplicationConfig config, Jdbi dbi) {
        LOG.info("Initializing DefaultAuthorizer with config {}", (Object)config.getAuthorizerConfiguration());
    }

    @Override
    public List<ResourcePermission> listPermissions(SecurityContext securityContext, String user) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        return (subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() ? PolicyEvaluator.getResourcePermissions(Permission.Access.ALLOW) : PolicyEvaluator.listPermission(subjectContext);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, String resourceType) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        return (subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() ? PolicyEvaluator.getResourcePermission(resourceType, Permission.Access.ALLOW) : PolicyEvaluator.getPermission(subjectContext, resourceType);
    }

    @Override
    public ResourcePermission getPermission(SecurityContext securityContext, String user, ResourceContextInterface resourceContext) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        return (subjectContext = this.changeSubjectContext(user, subjectContext)).isAdmin() ? PolicyEvaluator.getResourcePermission(resourceContext.getResource(), Permission.Access.ALLOW) : PolicyEvaluator.getPermission(subjectContext, resourceContext);
    }

    @Override
    public void authorize(SecurityContext securityContext, OperationContext operationContext, ResourceContextInterface resourceContext) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        if (subjectContext.isAdmin()) {
            return;
        }
        PolicyEvaluator.hasPermission(subjectContext, resourceContext, operationContext);
    }

    @Override
    public void authorizeAdmin(SecurityContext securityContext) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        if (subjectContext.isAdmin()) {
            return;
        }
        throw new AuthorizationException(CatalogExceptionMessage.notAdmin(securityContext.getUserPrincipal().getName()));
    }

    @Override
    public void authorizeAdminOrBot(SecurityContext securityContext) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        if (subjectContext.isAdmin() || subjectContext.isBot()) {
            return;
        }
        throw new AuthorizationException(CatalogExceptionMessage.notAdmin(securityContext.getUserPrincipal().getName()));
    }

    @Override
    public boolean shouldMaskPasswords(SecurityContext securityContext) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        return !subjectContext.isBot();
    }

    @Override
    public boolean authorizePII(SecurityContext securityContext, EntityReference owner) {
        SubjectContext subjectContext = DefaultAuthorizer.getSubjectContext(securityContext);
        return subjectContext.isAdmin() || subjectContext.isBot() || subjectContext.isOwner(owner);
    }

    public static SubjectContext getSubjectContext(SecurityContext securityContext) {
        if (securityContext == null || securityContext.getUserPrincipal() == null) {
            throw new AuthenticationException("No principal in security context");
        }
        return SubjectContext.getSubjectContext(SecurityUtil.getUserName(securityContext));
    }

    private SubjectContext changeSubjectContext(String user, SubjectContext loggedInUser) {
        if (user != null && !loggedInUser.getUser().getName().equals(user)) {
            if (!loggedInUser.isAdmin()) {
                throw new AuthorizationException(CatalogExceptionMessage.notAdmin(loggedInUser.getUser().getName()));
            }
            LOG.debug("Changing subject context from logged-in user to {}", (Object)user);
            return SubjectContext.getSubjectContext(user);
        }
        return loggedInUser;
    }
}

