/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import java.util.Comparator;
import java.util.function.Consumer;
import java.util.function.Function;

public final class LambdaExceptionUtil {
    public static <T, E extends Exception> Consumer<T> rethrowConsumer(ConsumerWithExceptions<T, E> consumer) {
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwActualException(exception);
            }
        };
    }

    public static <T, R, E extends Exception> Function<T, R> rethrowFunction(FunctionWithExceptions<T, R, E> function) {
        return t -> {
            try {
                return function.apply(t);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwActualException(exception);
                return null;
            }
        };
    }

    public static <T, E extends Exception> Comparator<T> rethrowComparator(ComparatorWithExceptions<T, E> comparator) {
        return (t1, t2) -> {
            try {
                return comparator.compare(t1, t2);
            }
            catch (Exception exception) {
                LambdaExceptionUtil.throwActualException(exception);
                return Integer.MIN_VALUE;
            }
        };
    }

    public static <T, E extends Exception> Comparator<T> ignoringComparator(ComparatorWithExceptions<T, E> comparator) {
        return (t1, t2) -> {
            try {
                return comparator.compare(t1, t2);
            }
            catch (Exception ignored) {
                return 0;
            }
        };
    }

    private static <E extends Exception> void throwActualException(Exception exception) throws E {
        throw exception;
    }

    @FunctionalInterface
    public static interface ComparatorWithExceptions<T, E extends Exception> {
        public int compare(T var1, T var2) throws E;
    }

    @FunctionalInterface
    public static interface FunctionWithExceptions<T, R, E extends Exception> {
        public R apply(T var1) throws E;
    }

    @FunctionalInterface
    public static interface ConsumerWithExceptions<T, E extends Exception> {
        public void accept(T var1) throws E;
    }
}

