/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.scheduler;

import org.apache.commons.lang.exception.ExceptionUtils;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppRunRecord;
import org.openmetadata.schema.entity.app.AppRunType;
import org.openmetadata.schema.entity.app.FailureContext;
import org.openmetadata.schema.entity.app.SuccessContext;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.util.JsonUtils;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.JobListener;

public abstract class AbstractOmAppJobListener
implements JobListener {
    private CollectionDAO collectionDAO;
    private static final String SCHEDULED_APP_RUN_EXTENSION = "AppScheduleRun";
    private static final String SCHEDULED_APP_RUN_RECORD_SCHEMA = "applicationRunRecord.json";
    public static final String APP_RUN_STATS = "AppRunStats";
    static final String JOB_LISTENER_NAME = "OM_JOB_LISTENER";

    protected AbstractOmAppJobListener(CollectionDAO dao) {
        this.collectionDAO = dao;
    }

    public String getName() {
        return JOB_LISTENER_NAME;
    }

    public void jobToBeExecuted(JobExecutionContext jobExecutionContext) {
        AppRunType runType = AppRunType.fromValue((String)((String)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"triggerType")));
        App jobApp = (App)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"applicationInfoKey");
        JobDataMap dataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        long jobStartTime = System.currentTimeMillis();
        AppRunRecord runRecord = new AppRunRecord().withAppId(jobApp.getId()).withStartTime(Long.valueOf(jobStartTime)).withTimestamp(Long.valueOf(jobStartTime)).withRunType(runType).withStatus(AppRunRecord.Status.RUNNING).withScheduleInfo(jobApp.getAppSchedule());
        dataMap.put(SCHEDULED_APP_RUN_EXTENSION, (Object)runRecord);
        this.collectionDAO.appExtensionTimeSeriesDao().insert(JsonUtils.pojoToJson(runRecord));
        this.doJobToBeExecuted(jobExecutionContext);
    }

    public void jobExecutionVetoed(JobExecutionContext jobExecutionContext) {
    }

    public void jobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
        boolean success;
        AppRunRecord runRecord = (AppRunRecord)jobExecutionContext.getJobDetail().getJobDataMap().get((Object)SCHEDULED_APP_RUN_EXTENSION);
        Object jobStats = jobExecutionContext.getJobDetail().getJobDataMap().get((Object)APP_RUN_STATS);
        long endTime = System.currentTimeMillis();
        runRecord.withEndTime(Long.valueOf(endTime));
        boolean bl = success = jobException == null;
        if (success) {
            runRecord.withStatus(AppRunRecord.Status.SUCCESS);
            SuccessContext context = new SuccessContext();
            context.getAdditionalProperties().put("stats", JsonUtils.getMap(jobStats));
            runRecord.setSuccessContext(context);
        } else {
            runRecord.withStatus(AppRunRecord.Status.FAILED);
            FailureContext context = new FailureContext();
            context.withAdditionalProperty("message", (Object)jobException.getMessage());
            context.withAdditionalProperty("stackTrace", (Object)ExceptionUtils.getStackTrace((Throwable)jobException));
            runRecord.setFailureContext(context);
        }
        this.collectionDAO.appExtensionTimeSeriesDao().update(runRecord.getAppId().toString(), JsonUtils.pojoToJson(runRecord), runRecord.getTimestamp());
        this.doJobWasExecuted(jobExecutionContext, jobException);
    }

    protected void doJobWasExecuted(JobExecutionContext jobExecutionContext, JobExecutionException jobException) {
    }

    protected void doJobToBeExecuted(JobExecutionContext jobExecutionContext) {
    }
}

