/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.analytics.RawCostAnalysisReportData;
import org.openmetadata.schema.dataInsight.DataInsightChartResult;
import org.openmetadata.schema.dataInsight.type.UnusedAssets;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class UnusedAssetsAggregator<H extends Iterable<S>, S, T>
implements DataInsightAggregatorInterface {
    private static final Logger LOG = LoggerFactory.getLogger(UnusedAssetsAggregator.class);
    private final H hits;

    public UnusedAssetsAggregator(H hits) {
        this.hits = hits;
    }

    @Override
    public DataInsightChartResult process(DataInsightChartResult.DataInsightChartType chartType) {
        List<Object> data = this.aggregate();
        return new DataInsightChartResult().withData(data).withChartType(chartType).withTotal(this.computeTotalHits(this.hits));
    }

    @Override
    public List<Object> aggregate() {
        ArrayList<Object> data = new ArrayList<Object>();
        ObjectMapper mapper = new ObjectMapper();
        for (Object hit : this.hits) {
            try {
                Object dataObject = this.getDataFromSource(hit);
                RawCostAnalysisReportData rawCostAnalysisReportData = JsonUtils.readValue(mapper.writeValueAsString(dataObject), RawCostAnalysisReportData.class);
                EntityReference entityReference = rawCostAnalysisReportData.getEntity();
                Long lastAccessed = rawCostAnalysisReportData.getLifeCycle().getAccessed().getTimestamp();
                Double sizeInByte = rawCostAnalysisReportData.getSizeInByte();
                UnusedAssets unusedAssets = new UnusedAssets().withEntity(entityReference).withLastAccessedAt(lastAccessed).withSizeInBytes(sizeInByte);
                data.add(unusedAssets);
            }
            catch (Exception e) {
                LOG.error("Error while parsing hits for UnusedData chart from ES", (Throwable)e);
            }
        }
        return data;
    }

    protected abstract Object getDataFromSource(S var1);

    protected abstract T totalHits(H var1);

    protected abstract Long getTotalHitsValue(T var1);

    private Integer computeTotalHits(H hits) {
        Long result = null;
        T totalHits = this.totalHits(hits);
        if (totalHits != null) {
            result = this.getTotalHitsValue(totalHits);
        }
        return result != null ? Integer.valueOf(result.intValue()) : null;
    }
}

