/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.exception;

import io.dropwizard.jersey.errors.ErrorMessage;
import java.sql.SQLIntegrityConstraintViolationException;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.Path;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.openmetadata.sdk.exception.WebServiceException;
import org.openmetadata.service.exception.BadRequestException;
import org.openmetadata.service.exception.EntityNotFoundException;
import org.openmetadata.service.exception.IngestionPipelineDeploymentException;
import org.openmetadata.service.exception.UnhandledServerException;
import org.openmetadata.service.security.AuthenticationException;
import org.openmetadata.service.security.AuthorizationException;
import org.postgresql.util.PSQLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CatalogGenericExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger LOG = LoggerFactory.getLogger(CatalogGenericExceptionMapper.class);

    public Response toResponse(Throwable ex) {
        LOG.debug(ex.getMessage());
        if (ex instanceof ProcessingException || ex instanceof IllegalArgumentException || ex instanceof javax.ws.rs.BadRequestException) {
            return this.getResponse(BadRequestException.of().getResponse(), ex);
        }
        if (ex instanceof UnableToExecuteStatementException) {
            if (ex.getCause() instanceof SQLIntegrityConstraintViolationException || ex.getCause() instanceof PSQLException && ex.getCause().getMessage().contains("duplicate")) {
                return this.getResponse(Response.Status.CONFLICT, "Entity already exists");
            }
        } else {
            if (ex instanceof EntityNotFoundException) {
                return this.getResponse(Response.Status.NOT_FOUND, ex.getLocalizedMessage());
            }
            if (ex instanceof IngestionPipelineDeploymentException) {
                return this.getResponse(Response.Status.BAD_REQUEST, ex.getLocalizedMessage());
            }
            if (ex instanceof AuthenticationException) {
                return this.getResponse(Response.Status.UNAUTHORIZED, ex.getLocalizedMessage());
            }
            if (ex instanceof AuthorizationException) {
                return this.getResponse(Response.Status.FORBIDDEN, ex.getLocalizedMessage());
            }
            if (ex instanceof WebServiceException) {
                Response response = ((WebServiceException)ex).getResponse();
                Response.Status.Family family = response.getStatusInfo().getFamily();
                if (family.equals((Object)Response.Status.Family.REDIRECTION)) {
                    return response;
                }
                if (family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                    this.throwException(ex);
                }
                return this.getResponse(response, ex);
            }
        }
        LOG.info("exception ", ex);
        this.logUnhandledException(ex);
        return new UnhandledServerException(ex.getMessage()).getResponse();
    }

    public Response getResponse(Response response, Throwable ex) {
        return Response.fromResponse((Response)response).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(response.getStatus(), ex.getLocalizedMessage())).build();
    }

    public Response getResponse(Response.Status status, String message) {
        return Response.status((Response.Status)status).type(MediaType.APPLICATION_JSON_TYPE).entity((Object)new ErrorMessage(status.getStatusCode(), message)).header("WWW-Authenticate", (Object)"om-auth").build();
    }

    private void logUnhandledException(Throwable ex) {
        Object errMessage = String.format("Got exception: [%s] / message [%s]", ex.getClass().getSimpleName(), ex.getMessage());
        StackTraceElement elem = this.findFirstResourceCallFromCallStack(ex.getStackTrace());
        String resourceClassName = null;
        if (elem != null) {
            errMessage = (String)errMessage + String.format(" / related resource location: [%s.%s](%s:%d)", elem.getClassName(), elem.getMethodName(), elem.getFileName(), elem.getLineNumber());
            resourceClassName = elem.getClassName();
        }
        Logger log = this.getEffectiveLogger(resourceClassName);
        log.error((String)errMessage, ex);
    }

    protected void throwException(Throwable exception) {
        long id = ThreadLocalRandom.current().nextLong();
        this.throwException(id, exception);
    }

    protected void throwException(long id, Throwable exception) {
        LOG.error(this.formatLogMessage(id), exception);
    }

    protected String formatLogMessage(long id) {
        return String.format("Error handling a request: %016x", id);
    }

    private StackTraceElement findFirstResourceCallFromCallStack(StackTraceElement[] stackTrace) {
        for (StackTraceElement stackTraceElement : stackTrace) {
            try {
                Class<?> aClass = Class.forName(stackTraceElement.getClassName());
                Path pathAnnotation = aClass.getAnnotation(Path.class);
                if (pathAnnotation == null) continue;
                return stackTraceElement;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return null;
    }

    private Logger getEffectiveLogger(String resourceClassName) {
        Logger log = LOG;
        if (resourceClassName != null) {
            log = LoggerFactory.getLogger((String)resourceClassName);
        }
        return log;
    }
}

