/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FeedMessage;

public class FeedMessageDecorator
implements MessageDecorator<FeedMessage> {
    @Override
    public String getBold() {
        return "**%s**";
    }

    @Override
    public String getLineBreak() {
        return " <br/> ";
    }

    @Override
    public String getAddMarker() {
        return "<span class=\"diff-added\">";
    }

    @Override
    public String getAddMarkerClose() {
        return "</span>";
    }

    @Override
    public String getRemoveMarker() {
        return "<span class=\"diff-removed\">";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "</span>";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn) {
        return String.format("[%s](/%s/%s)", fqn, entityType, fqn.trim());
    }

    @Override
    public FeedMessage buildMessage(ChangeEvent event) {
        return null;
    }
}

