/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.decorators;

import java.util.ArrayList;
import java.util.Map;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.service.ChangeEventConfig;
import org.openmetadata.service.events.subscription.AlertsRuleEvaluator;
import org.openmetadata.service.events.subscription.slack.SlackAttachment;
import org.openmetadata.service.events.subscription.slack.SlackMessage;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public class SlackMessageDecorator
implements MessageDecorator<SlackMessage> {
    @Override
    public String getBold() {
        return "*%s*";
    }

    @Override
    public String getLineBreak() {
        return "\n";
    }

    @Override
    public String getAddMarker() {
        return "*";
    }

    @Override
    public String getAddMarkerClose() {
        return "*";
    }

    @Override
    public String getRemoveMarker() {
        return "~";
    }

    @Override
    public String getRemoveMarkerClose() {
        return "~";
    }

    @Override
    public String getEntityUrl(String entityType, String fqn) {
        return String.format("<%s/%s/%s|%s>", ChangeEventConfig.getInstance().getOmUri(), entityType, fqn.trim().replaceAll(" ", "%20"), fqn.trim());
    }

    @Override
    public SlackMessage buildMessage(ChangeEvent event) {
        SlackMessage slackMessage = new SlackMessage();
        slackMessage.setUsername(event.getUserName());
        if (event.getEntity() != null) {
            String headerText;
            String eventType = event.getEntity() instanceof TestCase ? "testSuite" : event.getEntityType();
            if (eventType.equals("query")) {
                headerTxt = "%s posted on " + eventType;
                headerText = String.format(headerTxt, event.getUserName());
            } else {
                headerTxt = "%s posted on " + eventType + " %s";
                headerText = String.format(headerTxt, event.getUserName(), this.getEntityUrl(event.getEntityType(), event.getEntityFullyQualifiedName()));
            }
            slackMessage.setText(headerText);
        }
        Map<MessageParser.EntityLink, String> messages = FormatterUtil.getFormattedMessages(this, event.getChangeDescription(), AlertsRuleEvaluator.getEntity(event));
        ArrayList<SlackAttachment> attachmentList = new ArrayList<SlackAttachment>();
        for (Map.Entry<MessageParser.EntityLink, String> entry : messages.entrySet()) {
            SlackAttachment attachment = new SlackAttachment();
            ArrayList<String> mark = new ArrayList<String>();
            mark.add("text");
            attachment.setMarkdownIn(mark);
            attachment.setText(entry.getValue());
            attachmentList.add(attachment);
        }
        slackMessage.setAttachments(attachmentList.toArray(new SlackAttachment[0]));
        return slackMessage;
    }
}

