/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Container;
import org.openmetadata.schema.entity.data.DashboardDataModel;
import org.openmetadata.schema.entity.services.StorageService;
import org.openmetadata.schema.type.Column;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.ColumnUtil;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;

public class ContainerRepository
extends EntityRepository<Container> {
    private static final String CONTAINER_UPDATE_FIELDS = "dataModel";
    private static final String CONTAINER_PATCH_FIELDS = "dataModel";

    public ContainerRepository() {
        super("v1/containers/", "container", Container.class, Entity.getCollectionDAO().containerDAO(), "dataModel", "dataModel");
        this.supportsSearch = true;
    }

    @Override
    public Container setFields(Container container, EntityUtil.Fields fields) {
        this.setDefaultFields(container);
        container.setParent(fields.contains("parent") ? this.getParent(container) : container.getParent());
        if (container.getDataModel() != null) {
            this.populateDataModelColumnTags(fields.contains("tags"), container.getDataModel().getColumns());
        }
        return container;
    }

    @Override
    public Container clearFields(Container container, EntityUtil.Fields fields) {
        container.setParent(fields.contains("parent") ? container.getParent() : null);
        return container.withDataModel(fields.contains("dataModel") ? container.getDataModel() : null);
    }

    private void populateDataModelColumnTags(boolean setTags, List<Column> columns) {
        for (Column c : CommonUtil.listOrEmpty(columns)) {
            c.setTags(setTags ? this.getTags(c.getFullyQualifiedName()) : null);
            this.populateDataModelColumnTags(setTags, c.getChildren());
        }
    }

    private void setDefaultFields(Container container) {
        EntityReference parentServiceRef = this.getFromEntityRef(container.getId(), Relationship.CONTAINS, "storageService", true);
        container.withService(parentServiceRef);
    }

    @Override
    public void setFullyQualifiedName(Container container) {
        if (container.getParent() != null) {
            container.setFullyQualifiedName(FullyQualifiedName.add(container.getParent().getFullyQualifiedName(), container.getName()));
        } else {
            container.setFullyQualifiedName(FullyQualifiedName.add(container.getService().getFullyQualifiedName(), container.getName()));
        }
        if (container.getDataModel() != null) {
            this.setColumnFQN(container.getFullyQualifiedName(), container.getDataModel().getColumns());
        }
    }

    private void setColumnFQN(String parentFQN, List<Column> columns) {
        columns.forEach(c -> {
            String columnFqn = FullyQualifiedName.add(parentFQN, c.getName());
            c.setFullyQualifiedName(columnFqn);
            if (c.getChildren() != null) {
                this.setColumnFQN(columnFqn, c.getChildren());
            }
        });
    }

    @Override
    public void prepare(Container container, boolean update) {
        StorageService storageService = (StorageService)Entity.getEntity(container.getService(), "", Include.NON_DELETED);
        container.setService(storageService.getEntityReference());
        container.setServiceType(storageService.getServiceType());
        if (container.getParent() != null) {
            Container parent = (Container)Entity.getEntity(container.getParent(), "owner", Include.ALL);
            container.withParent(parent.getEntityReference());
        }
        if (container.getDataModel() != null) {
            this.addDerivedColumnTags(container.getDataModel().getColumns());
            this.validateColumnTags(container.getDataModel().getColumns());
        }
    }

    @Override
    public void storeEntity(Container container, boolean update) {
        EntityReference storageService = container.getService();
        EntityReference parent = container.getParent();
        container.withService(null).withParent(null);
        ArrayList columnWithTags = Lists.newArrayList();
        if (container.getDataModel() != null) {
            columnWithTags.addAll(container.getDataModel().getColumns());
            container.getDataModel().setColumns(ColumnUtil.cloneWithoutTags(columnWithTags));
            container.getDataModel().getColumns().forEach(column -> column.setTags(null));
        }
        this.store(container, update);
        container.withService(storageService).withParent(parent);
        if (container.getDataModel() != null) {
            container.getDataModel().setColumns((List)columnWithTags);
        }
    }

    @Override
    public void restorePatchAttributes(Container original, Container updated) {
        updated.withFullyQualifiedName(original.getFullyQualifiedName()).withService(original.getService()).withParent(original.getParent()).withName(original.getName()).withId(original.getId());
    }

    @Override
    public void storeRelationships(Container container) {
        EntityReference service = container.getService();
        this.addRelationship(service.getId(), container.getId(), service.getType(), "container", Relationship.CONTAINS);
        EntityReference parentReference = container.getParent();
        if (parentReference != null) {
            this.addRelationship(parentReference.getId(), container.getId(), "container", "container", Relationship.CONTAINS);
        }
    }

    @Override
    public EntityRepository.EntityUpdater getUpdater(Container original, Container updated, EntityRepository.Operation operation) {
        return new ContainerUpdater(original, updated, operation);
    }

    @Override
    public void applyTags(Container container) {
        super.applyTags(container);
        if (container.getDataModel() != null) {
            this.applyTags(container.getDataModel().getColumns());
        }
    }

    @Override
    public EntityInterface getParentEntity(Container entity, String fields) {
        return (EntityInterface)Entity.getEntity(entity.getService(), fields, Include.NON_DELETED);
    }

    @Override
    private void applyTags(List<Column> columns) {
        for (Column column : columns) {
            this.applyTags(column.getTags(), column.getFullyQualifiedName());
            if (column.getChildren() == null) continue;
            this.applyTags(column.getChildren());
        }
    }

    @Override
    public List<TagLabel> getAllTags(EntityInterface entity) {
        ArrayList<TagLabel> allTags = new ArrayList<TagLabel>();
        Container container = (Container)entity;
        EntityUtil.mergeTags(allTags, container.getTags());
        if (container.getDataModel() != null) {
            for (Column column : CommonUtil.listOrEmpty((List)container.getDataModel().getColumns())) {
                EntityUtil.mergeTags(allTags, column.getTags());
            }
        }
        return allTags;
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        MessageParser.EntityLink entityLink = threadContext.getAbout();
        if (entityLink.getFieldName().equals("dataModel")) {
            TaskType taskType = threadContext.getThread().getTask().getType();
            if (EntityUtil.isDescriptionTask(taskType)) {
                return new DataModelDescriptionTaskWorkflow(threadContext);
            }
            if (EntityUtil.isTagTask(taskType)) {
                return new DataModelTagTaskWorkflow(threadContext);
            }
            throw new IllegalArgumentException(String.format("Invalid task type %s", taskType));
        }
        return super.getTaskWorkflow(threadContext);
    }

    private void addDerivedColumnTags(List<Column> columns) {
        if (CommonUtil.nullOrEmpty(columns)) {
            return;
        }
        for (Column column : columns) {
            column.setTags(this.addDerivedTags(column.getTags()));
            if (column.getChildren() == null) continue;
            this.addDerivedColumnTags(column.getChildren());
        }
    }

    private void validateColumnTags(List<Column> columns) {
        for (Column column : columns) {
            this.checkMutuallyExclusive(column.getTags());
            if (column.getChildren() == null) continue;
            this.validateColumnTags(column.getChildren());
        }
    }

    public class ContainerUpdater
    extends EntityRepository.ColumnEntityUpdater {
        public ContainerUpdater(Container original, Container updated, EntityRepository.Operation operation) {
            super((EntityRepository)ContainerRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.updateDataModel((Container)this.original, (Container)this.updated);
            this.recordChange("prefix", ((Container)this.original).getPrefix(), ((Container)this.updated).getPrefix());
            ArrayList addedItems = new ArrayList();
            ArrayList deletedItems = new ArrayList();
            this.recordListChange("fileFormats", ((Container)this.original).getFileFormats(), ((Container)this.updated).getFileFormats(), addedItems, deletedItems, EntityUtil.containerFileFormatMatch);
            this.recordChange("numberOfObjects", ((Container)this.original).getNumberOfObjects(), ((Container)this.updated).getNumberOfObjects(), false, EntityUtil.objectMatch, false);
            this.recordChange("size", ((Container)this.original).getSize(), ((Container)this.updated).getSize(), false, EntityUtil.objectMatch, false);
            this.recordChange("sourceUrl", ((Container)this.original).getSourceUrl(), ((Container)this.updated).getSourceUrl());
        }

        private void updateDataModel(Container original, Container updated) {
            if (original.getDataModel() == null || updated.getDataModel() == null) {
                this.recordChange("dataModel", original.getDataModel(), updated.getDataModel(), true);
            }
            if (original.getDataModel() != null && updated.getDataModel() != null) {
                this.updateColumns("dataModel.columns", original.getDataModel().getColumns(), updated.getDataModel().getColumns(), (BiPredicate)EntityUtil.columnMatch);
                this.recordChange("dataModel.partition", original.getDataModel().getIsPartitioned(), updated.getDataModel().getIsPartitioned());
            }
        }
    }

    static class DataModelDescriptionTaskWorkflow
    extends EntityRepository.DescriptionTaskWorkflow {
        private final Column column;

        DataModelDescriptionTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            DashboardDataModel dataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", threadContext.getAboutEntity().getId(), "dataModel", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)dataModel);
            this.column = EntityUtil.findColumn(dataModel.getColumns(), this.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            this.column.setDescription(resolveTask.getNewValue());
            return this.threadContext.getAboutEntity();
        }
    }

    static class DataModelTagTaskWorkflow
    extends EntityRepository.TagTaskWorkflow {
        private final Column column;

        DataModelTagTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
            DashboardDataModel dataModel = (DashboardDataModel)Entity.getEntity("dashboardDataModel", threadContext.getAboutEntity().getId(), "dataModel,tags", Include.ALL);
            threadContext.setAboutEntity((EntityInterface)dataModel);
            this.column = EntityUtil.findColumn(dataModel.getColumns(), this.getAbout().getArrayFieldName());
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            List<TagLabel> tags = JsonUtils.readObjects(resolveTask.getNewValue(), TagLabel.class);
            this.column.setTags(tags);
            return this.threadContext.getAboutEntity();
        }
    }
}

