/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.json.JsonPatch;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.api.feed.CloseTask;
import org.openmetadata.schema.api.feed.ResolveTask;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.entity.feed.Thread;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.ProviderType;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.schema.type.TaskDetails;
import org.openmetadata.schema.type.TaskStatus;
import org.openmetadata.schema.type.TaskType;
import org.openmetadata.schema.type.ThreadType;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.FeedRepository;
import org.openmetadata.service.resources.feeds.FeedResource;
import org.openmetadata.service.resources.feeds.MessageParser;
import org.openmetadata.service.security.AuthorizationException;
import org.openmetadata.service.util.EntityUtil;
import org.openmetadata.service.util.FullyQualifiedName;
import org.openmetadata.service.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlossaryTermRepository
extends EntityRepository<GlossaryTerm> {
    private static final Logger LOG = LoggerFactory.getLogger(GlossaryTermRepository.class);
    private static final String UPDATE_FIELDS = "references,relatedTerms,synonyms";
    private static final String PATCH_FIELDS = "references,relatedTerms,synonyms";

    public GlossaryTermRepository() {
        super("v1/glossaryTerms/", "glossaryTerm", GlossaryTerm.class, Entity.getCollectionDAO().glossaryTermDAO(), "references,relatedTerms,synonyms", "references,relatedTerms,synonyms");
        this.supportsSearch = true;
    }

    @Override
    public GlossaryTerm setFields(GlossaryTerm entity, EntityUtil.Fields fields) {
        entity.withParent(this.getParent(entity)).withGlossary(this.getGlossary(entity));
        entity.setRelatedTerms(fields.contains("relatedTerms") ? this.getRelatedTerms(entity) : entity.getRelatedTerms());
        return entity.withUsageCount(fields.contains("usageCount") ? this.getUsageCount(entity) : entity.getUsageCount());
    }

    @Override
    public GlossaryTerm clearFields(GlossaryTerm entity, EntityUtil.Fields fields) {
        entity.setRelatedTerms(fields.contains("relatedTerms") ? entity.getRelatedTerms() : null);
        return entity.withUsageCount(fields.contains("usageCount") ? entity.getUsageCount() : null);
    }

    @Override
    public GlossaryTerm setInheritedFields(GlossaryTerm glossaryTerm, EntityUtil.Fields fields) {
        Object parent = glossaryTerm.getParent() != null ? this.get(null, glossaryTerm.getParent().getId(), this.getFields("owner,reviewers,domain")) : (EntityInterface)Entity.getEntity(glossaryTerm.getGlossary(), "owner,reviewers,domain", Include.ALL);
        this.inheritOwner(glossaryTerm, fields, (EntityInterface)parent);
        this.inheritDomain(glossaryTerm, fields, (EntityInterface)parent);
        this.inheritReviewers(glossaryTerm, fields, (EntityInterface)parent);
        return glossaryTerm;
    }

    private Integer getUsageCount(GlossaryTerm term) {
        return this.daoCollection.tagUsageDAO().getTagCount(TagLabel.TagSource.GLOSSARY.ordinal(), term.getFullyQualifiedName());
    }

    private List<EntityReference> getRelatedTerms(GlossaryTerm entity) {
        return this.findBoth(entity.getId(), "glossaryTerm", Relationship.RELATED_TO, "glossaryTerm");
    }

    @Override
    public void prepare(GlossaryTerm entity, boolean update) {
        GlossaryTerm parentTerm;
        List parentReviewers = null;
        GlossaryTerm glossaryTerm = parentTerm = entity.getParent() != null ? (GlossaryTerm)Entity.getEntity(entity.getParent().withType("glossaryTerm"), "owner,reviewers", Include.NON_DELETED) : null;
        if (parentTerm != null) {
            parentReviewers = parentTerm.getReviewers();
            entity.setParent(parentTerm.getEntityReference());
        }
        Glossary glossary = (Glossary)Entity.getEntity(entity.getGlossary(), "reviewers", Include.NON_DELETED);
        entity.setGlossary(glossary.getEntityReference());
        parentReviewers = parentReviewers != null ? parentReviewers : glossary.getReviewers();
        this.validateHierarchy(entity);
        EntityUtil.populateEntityReferences(entity.getRelatedTerms());
        EntityUtil.populateEntityReferences(entity.getReviewers());
        if (!update || entity.getStatus() == null) {
            entity.setStatus(!CommonUtil.nullOrEmpty((List)parentReviewers) ? GlossaryTerm.Status.DRAFT : GlossaryTerm.Status.APPROVED);
        }
    }

    @Override
    public void storeEntity(GlossaryTerm entity, boolean update) {
        EntityReference glossary = entity.getGlossary();
        EntityReference parentTerm = entity.getParent();
        List relatedTerms = entity.getRelatedTerms();
        List reviewers = entity.getReviewers();
        entity.withGlossary(null).withParent(null).withRelatedTerms(relatedTerms).withReviewers(null);
        this.store(entity, update);
        entity.withGlossary(glossary).withParent(parentTerm).withRelatedTerms(relatedTerms).withReviewers(reviewers);
    }

    @Override
    public void storeRelationships(GlossaryTerm entity) {
        this.addGlossaryRelationship(entity);
        this.addParentRelationship(entity);
        for (EntityReference relTerm : CommonUtil.listOrEmpty((List)entity.getRelatedTerms())) {
            this.addRelationship(entity.getId(), relTerm.getId(), "glossaryTerm", "glossaryTerm", Relationship.RELATED_TO, true);
        }
        for (EntityReference reviewer : CommonUtil.listOrEmpty((List)entity.getReviewers())) {
            this.addRelationship(reviewer.getId(), entity.getId(), "user", "glossaryTerm", Relationship.REVIEWS);
        }
    }

    @Override
    public void restorePatchAttributes(GlossaryTerm original, GlossaryTerm updated) {
        updated.withChildren(original.getChildren());
    }

    @Override
    public void setFullyQualifiedName(GlossaryTerm entity) {
        if (entity.getParent() == null) {
            entity.setFullyQualifiedName(FullyQualifiedName.build(entity.getGlossary().getFullyQualifiedName(), entity.getName()));
        } else {
            EntityReference parent = entity.getParent();
            entity.setFullyQualifiedName(FullyQualifiedName.add(parent.getFullyQualifiedName(), entity.getName()));
        }
    }

    protected EntityReference getGlossary(GlossaryTerm term) {
        Relationship relationship = term.getParent() != null ? Relationship.HAS : Relationship.CONTAINS;
        return term.getGlossary() != null ? term.getGlossary() : this.getFromEntityRef(term.getId(), relationship, "glossary", true);
    }

    public EntityReference getGlossary(String id) {
        return Entity.getEntityReferenceById("glossary", UUID.fromString(id), Include.ALL);
    }

    public GlossaryTermUpdater getUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
        return new GlossaryTermUpdater(original, updated, operation);
    }

    @Override
    protected void postCreate(GlossaryTerm entity) {
        super.postCreate(entity);
        if (entity.getStatus() == GlossaryTerm.Status.DRAFT) {
            this.createApprovalTask(entity, entity.getReviewers());
        }
    }

    @Override
    public void postUpdate(GlossaryTerm original, GlossaryTerm updated) {
        super.postUpdate(original, updated);
        if (original.getStatus() == GlossaryTerm.Status.DRAFT) {
            if (updated.getStatus() == GlossaryTerm.Status.APPROVED) {
                this.closeApprovalTask(updated, "Approved the glossary term");
            } else if (updated.getStatus() == GlossaryTerm.Status.REJECTED) {
                this.closeApprovalTask(updated, "Rejected the glossary term");
            }
        }
    }

    @Override
    protected void preDelete(GlossaryTerm entity, String deletedBy) {
        if (GlossaryTerm.Status.DRAFT.equals((Object)entity.getStatus())) {
            this.checkUpdatedByReviewer(entity, deletedBy);
        }
    }

    @Override
    protected void postDelete(GlossaryTerm entity) {
        this.daoCollection.tagUsageDAO().deleteTagLabels(TagLabel.TagSource.GLOSSARY.ordinal(), entity.getFullyQualifiedName());
    }

    @Override
    public FeedRepository.TaskWorkflow getTaskWorkflow(FeedRepository.ThreadContext threadContext) {
        this.validateTaskThread(threadContext);
        TaskType taskType = threadContext.getThread().getTask().getType();
        if (EntityUtil.isApprovalTask(taskType)) {
            return new ApprovalTaskWorkflow(threadContext);
        }
        return super.getTaskWorkflow(threadContext);
    }

    @Override
    public EntityInterface getParentEntity(GlossaryTerm entity, String fields) {
        return entity.getParent() != null ? (EntityInterface)Entity.getEntity(entity.getParent(), fields, Include.NON_DELETED) : (EntityInterface)Entity.getEntity(entity.getGlossary(), fields, Include.NON_DELETED);
    }

    private void addGlossaryRelationship(GlossaryTerm term) {
        Relationship relationship = term.getParent() != null ? Relationship.HAS : Relationship.CONTAINS;
        this.addRelationship(term.getGlossary().getId(), term.getId(), "glossary", "glossaryTerm", relationship);
    }

    private void addParentRelationship(GlossaryTerm term) {
        if (term.getParent() != null) {
            this.addRelationship(term.getParent().getId(), term.getId(), "glossaryTerm", "glossaryTerm", Relationship.CONTAINS);
        }
    }

    private void validateHierarchy(GlossaryTerm term) {
        if (term.getParent() == null) {
            return;
        }
        String glossaryFqn = FullyQualifiedName.build(term.getGlossary().getName());
        if (!term.getParent().getFullyQualifiedName().startsWith(glossaryFqn)) {
            throw new IllegalArgumentException(String.format("Invalid hierarchy - parent [%s] does not belong to glossary[%s]", term.getParent().getFullyQualifiedName(), term.getGlossary().getFullyQualifiedName()));
        }
    }

    private void checkUpdatedByReviewer(GlossaryTerm term, String updatedBy) {
        boolean isReviewer;
        List reviewers = term.getReviewers();
        if (!CommonUtil.nullOrEmpty((List)reviewers) && !(isReviewer = reviewers.stream().anyMatch(e -> e.getName().equals(updatedBy) || e.getFullyQualifiedName().equals(updatedBy)))) {
            throw new AuthorizationException(CatalogExceptionMessage.notReviewer(updatedBy));
        }
    }

    private void createApprovalTask(GlossaryTerm entity, List<EntityReference> parentReviewers) {
        TaskDetails taskDetails = new TaskDetails().withAssignees(FeedResource.formatAssignees(parentReviewers)).withType(TaskType.RequestApproval).withStatus(TaskStatus.Open);
        MessageParser.EntityLink about = new MessageParser.EntityLink(this.entityType, entity.getFullyQualifiedName());
        Thread thread = new Thread().withId(UUID.randomUUID()).withThreadTs(Long.valueOf(System.currentTimeMillis())).withMessage("Approval required for ").withCreatedBy(entity.getUpdatedBy()).withAbout(about.getLinkString()).withType(ThreadType.Task).withTask(taskDetails).withUpdatedBy(entity.getUpdatedBy()).withUpdatedAt(Long.valueOf(System.currentTimeMillis()));
        FeedRepository feedRepository = Entity.getFeedRepository();
        feedRepository.create(thread);
    }

    private void closeApprovalTask(GlossaryTerm entity, String comment) {
        MessageParser.EntityLink about = new MessageParser.EntityLink("glossaryTerm", entity.getFullyQualifiedName());
        FeedRepository feedRepository = Entity.getFeedRepository();
        Thread taskThread = feedRepository.getTask(about, TaskType.RequestApproval);
        if (TaskStatus.Open.equals((Object)taskThread.getTask().getStatus())) {
            feedRepository.closeTask(taskThread, entity.getUpdatedBy(), new CloseTask().withComment(comment));
        }
    }

    public class GlossaryTermUpdater
    extends EntityRepository.EntityUpdater {
        public GlossaryTermUpdater(GlossaryTerm original, GlossaryTerm updated, EntityRepository.Operation operation) {
            super((EntityRepository)GlossaryTermRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.validateParent();
            this.updateStatus((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateSynonyms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateReferences((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateRelatedTerms((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateReviewers((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateName((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
            this.updateParent((GlossaryTerm)this.original, (GlossaryTerm)this.updated);
        }

        @Override
        protected void updateTags(String fqn, String fieldName, List<TagLabel> origTags, List<TagLabel> updatedTags) {
            super.updateTags(fqn, fieldName, origTags, updatedTags);
            List<String> targetFQNList = GlossaryTermRepository.this.daoCollection.tagUsageDAO().getTargetFQNs(TagLabel.TagSource.CLASSIFICATION.ordinal(), fqn);
            for (String targetFQN : targetFQNList) {
                GlossaryTermRepository.this.applyTags(updatedTags, targetFQN);
            }
        }

        private void updateStatus(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            if (origTerm.getStatus() == updatedTerm.getStatus()) {
                return;
            }
            if (origTerm.getStatus() == GlossaryTerm.Status.DRAFT && (updatedTerm.getStatus() == GlossaryTerm.Status.APPROVED || updatedTerm.getStatus() == GlossaryTerm.Status.REJECTED)) {
                GlossaryTermRepository.this.checkUpdatedByReviewer(origTerm, updatedTerm.getUpdatedBy());
            }
            this.recordChange("status", origTerm.getStatus(), updatedTerm.getStatus());
        }

        private void updateSynonyms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origSynonyms = CommonUtil.listOrEmpty((List)origTerm.getSynonyms());
            List updatedSynonyms = CommonUtil.listOrEmpty((List)updatedTerm.getSynonyms());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("synonyms", origSynonyms, updatedSynonyms, added, deleted, EntityUtil.stringMatch);
        }

        private void updateReferences(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origReferences = CommonUtil.listOrEmpty((List)origTerm.getReferences());
            List updatedReferences = CommonUtil.listOrEmpty((List)updatedTerm.getReferences());
            ArrayList added = new ArrayList();
            ArrayList deleted = new ArrayList();
            this.recordListChange("references", origReferences, updatedReferences, added, deleted, EntityUtil.termReferenceMatch);
        }

        private void updateRelatedTerms(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origRelated = CommonUtil.listOrEmpty((List)origTerm.getRelatedTerms());
            List updatedRelated = CommonUtil.listOrEmpty((List)updatedTerm.getRelatedTerms());
            this.updateToRelationships("relatedTerms", "glossaryTerm", origTerm.getId(), Relationship.RELATED_TO, "glossaryTerm", origRelated, updatedRelated, true);
        }

        private void updateReviewers(GlossaryTerm origTerm, GlossaryTerm updatedTerm) {
            List origReviewers = CommonUtil.listOrEmpty((List)origTerm.getReviewers());
            List updatedReviewers = CommonUtil.listOrEmpty((List)updatedTerm.getReviewers());
            this.updateFromRelationships("reviewers", "user", origReviewers, updatedReviewers, Relationship.REVIEWS, "glossaryTerm", origTerm.getId());
        }

        public void updateName(GlossaryTerm original, GlossaryTerm updated) {
            if (!original.getName().equals(updated.getName())) {
                if (ProviderType.SYSTEM.equals((Object)original.getProvider())) {
                    throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityRenameNotAllowed(original.getName(), GlossaryTermRepository.this.entityType));
                }
                LOG.info("Glossary term name changed from {} to {}", (Object)original.getName(), (Object)updated.getName());
                GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.GLOSSARY.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
                this.recordChange("name", original.getName(), updated.getName());
                this.invalidateTerm(original.getId());
            }
        }

        private void updateParent(GlossaryTerm original, GlossaryTerm updated) {
            UUID newParentId;
            UUID oldParentId = EntityUtil.getId(original.getParent());
            boolean parentChanged = !Objects.equals(oldParentId, newParentId = EntityUtil.getId(updated.getParent()));
            UUID oldGlossaryId = EntityUtil.getId(original.getGlossary());
            UUID newGlossaryId = EntityUtil.getId(updated.getGlossary());
            boolean glossaryChanged = !Objects.equals(oldGlossaryId, newGlossaryId);
            GlossaryTermRepository.this.daoCollection.glossaryTermDAO().updateFqn(original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            GlossaryTermRepository.this.daoCollection.tagUsageDAO().rename(TagLabel.TagSource.GLOSSARY.ordinal(), original.getFullyQualifiedName(), updated.getFullyQualifiedName());
            if (glossaryChanged) {
                this.updateGlossaryRelationship(original, updated);
                this.recordChange("glossary", original.getGlossary(), updated.getGlossary(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTerm(original.getId());
            }
            if (parentChanged) {
                this.updateGlossaryRelationship(original, updated);
                this.updateParentRelationship(original, updated);
                this.recordChange("parent", original.getParent(), updated.getParent(), true, EntityUtil.entityReferenceMatch);
                this.invalidateTerm(original.getId());
            }
        }

        private void validateParent() {
            String newParentFqn;
            String fqn = ((GlossaryTerm)this.original).getFullyQualifiedName();
            String string = newParentFqn = ((GlossaryTerm)this.updated).getParent() == null ? null : ((GlossaryTerm)this.updated).getParent().getFullyQualifiedName();
            if (newParentFqn != null && FullyQualifiedName.isParent(newParentFqn, fqn)) {
                throw new IllegalArgumentException(CatalogExceptionMessage.invalidGlossaryTermMove(fqn, newParentFqn));
            }
        }

        private void updateGlossaryRelationship(GlossaryTerm orig, GlossaryTerm updated) {
            this.deleteGlossaryRelationship(orig);
            GlossaryTermRepository.this.addGlossaryRelationship(updated);
        }

        private void deleteGlossaryRelationship(GlossaryTerm term) {
            Relationship relationship = term.getParent() == null ? Relationship.CONTAINS : Relationship.HAS;
            GlossaryTermRepository.this.deleteRelationship(term.getGlossary().getId(), "glossary", term.getId(), "glossaryTerm", relationship);
        }

        private void updateParentRelationship(GlossaryTerm orig, GlossaryTerm updated) {
            this.deleteParentRelationship(orig);
            GlossaryTermRepository.this.addParentRelationship(updated);
        }

        private void deleteParentRelationship(GlossaryTerm term) {
            if (term.getParent() != null) {
                GlossaryTermRepository.this.deleteRelationship(term.getParent().getId(), "glossaryTerm", term.getId(), "glossaryTerm", Relationship.CONTAINS);
            }
        }

        private void invalidateTerm(UUID termId) {
            List<CollectionDAO.EntityRelationshipRecord> tagRecords = GlossaryTermRepository.this.findToRecords(termId, "glossaryTerm", Relationship.CONTAINS, "glossaryTerm");
            EntityRepository.CACHE_WITH_ID.invalidate((Object)new ImmutablePair((Object)"glossaryTerm", (Object)termId));
            for (CollectionDAO.EntityRelationshipRecord tagRecord : tagRecords) {
                this.invalidateTerm(tagRecord.getId());
            }
        }
    }

    public static class ApprovalTaskWorkflow
    extends FeedRepository.TaskWorkflow {
        ApprovalTaskWorkflow(FeedRepository.ThreadContext threadContext) {
            super(threadContext);
        }

        @Override
        public EntityInterface performTask(String user, ResolveTask resolveTask) {
            GlossaryTerm glossaryTerm = (GlossaryTerm)this.threadContext.getAboutEntity();
            glossaryTerm.setStatus(GlossaryTerm.Status.APPROVED);
            return glossaryTerm;
        }

        @Override
        protected void closeTask(String user, CloseTask closeTask) {
            GlossaryTerm term = (GlossaryTerm)this.threadContext.getAboutEntity();
            if (term.getStatus() == GlossaryTerm.Status.DRAFT) {
                String origJson = JsonUtils.pojoToJson(term);
                term.setStatus(GlossaryTerm.Status.REJECTED);
                String updatedJson = JsonUtils.pojoToJson(term);
                JsonPatch patch = JsonUtils.getJsonPatch(origJson, updatedJson);
                EntityRepository<? extends EntityInterface> repository = this.threadContext.getEntityRepository();
                repository.patch(null, term.getId(), user, patch);
            }
        }
    }
}

