/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.jdbi3;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.jdbi.v3.sqlobject.transaction.Transaction;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.policies.Policy;
import org.openmetadata.schema.entity.policies.accessControl.Rule;
import org.openmetadata.schema.type.EntityReference;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.schema.type.Relationship;
import org.openmetadata.service.Entity;
import org.openmetadata.service.exception.CatalogExceptionMessage;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.security.policyevaluator.CompiledRule;
import org.openmetadata.service.security.policyevaluator.OperationContext;
import org.openmetadata.service.util.EntityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PolicyRepository
extends EntityRepository<Policy> {
    private static final Logger LOG = LoggerFactory.getLogger(PolicyRepository.class);
    public static final String ENABLED = "enabled";

    public PolicyRepository() {
        super("v1/policies/", "policy", Policy.class, Entity.getCollectionDAO().policyDAO(), "", "");
    }

    @Override
    public Policy setFields(Policy policy, EntityUtil.Fields fields) {
        policy.setTeams(fields.contains("teams") ? this.getTeams(policy) : policy.getTeams());
        return policy.withRoles(fields.contains("roles") ? this.getRoles(policy) : policy.getRoles());
    }

    @Override
    public Policy clearFields(Policy policy, EntityUtil.Fields fields) {
        policy.setTeams(fields.contains("teams") ? policy.getTeams() : null);
        return policy.withRoles(fields.contains("roles") ? policy.getRoles() : null);
    }

    private List<EntityReference> getTeams(Policy policy) {
        return this.findFrom(policy.getId(), "policy", Relationship.HAS, "team");
    }

    private List<EntityReference> getRoles(Policy policy) {
        return this.findFrom(policy.getId(), "policy", Relationship.HAS, "role");
    }

    @Override
    public void prepare(Policy policy, boolean update) {
        this.validateRules(policy);
    }

    @Override
    public void storeEntity(Policy policy, boolean update) {
        this.store(policy, update);
    }

    @Override
    public void storeRelationships(Policy policy) {
    }

    public PolicyUpdater getUpdater(Policy original, Policy updated, EntityRepository.Operation operation) {
        return new PolicyUpdater(original, updated, operation);
    }

    @Override
    protected void preDelete(Policy entity, String updateBy) {
        if (Boolean.FALSE.equals(entity.getAllowDelete())) {
            throw new IllegalArgumentException(CatalogExceptionMessage.systemEntityDeleteNotAllowed(entity.getName(), "policy"));
        }
    }

    public void validateRules(Policy policy) {
        List rules = policy.getRules();
        if (CommonUtil.nullOrEmpty((List)rules)) {
            throw new IllegalArgumentException("At least one rule is required in a policy");
        }
        for (Rule rule : rules) {
            CompiledRule.validateExpression(rule.getCondition(), Boolean.class);
            rule.getResources().sort(String.CASE_INSENSITIVE_ORDER);
            rule.getOperations().sort(Comparator.comparing(MetadataOperation::value));
            rule.setResources(PolicyRepository.filterRedundantResources(rule.getResources()));
            rule.setOperations(PolicyRepository.filterRedundantOperations(rule.getOperations()));
        }
        rules.sort(Comparator.comparing(Rule::getName));
    }

    public static List<String> filterRedundantResources(List<String> resources) {
        boolean containsAllResources = resources.stream().anyMatch("All"::equalsIgnoreCase);
        return containsAllResources ? new ArrayList<String>(List.of("All")) : resources;
    }

    public static List<MetadataOperation> filterRedundantOperations(List<MetadataOperation> operations) {
        boolean containsEditAll;
        boolean containsViewAll = operations.stream().anyMatch(o -> o.equals((Object)MetadataOperation.VIEW_ALL));
        if (containsViewAll) {
            operations = operations.stream().filter(o -> o.equals((Object)MetadataOperation.VIEW_ALL) || !OperationContext.isViewOperation(o)).collect(Collectors.toList());
        }
        if (containsEditAll = operations.stream().anyMatch(o -> o.equals((Object)MetadataOperation.EDIT_ALL))) {
            operations = operations.stream().filter(o -> o.equals((Object)MetadataOperation.EDIT_ALL) || !OperationContext.isEditOperation(o)).collect(Collectors.toList());
        }
        return operations;
    }

    public class PolicyUpdater
    extends EntityRepository.EntityUpdater {
        public PolicyUpdater(Policy original, Policy updated, EntityRepository.Operation operation) {
            super((EntityRepository)PolicyRepository.this, (EntityInterface)original, (EntityInterface)updated, operation);
        }

        @Override
        @Transaction
        public void entitySpecificUpdate() {
            this.recordChange(PolicyRepository.ENABLED, ((Policy)this.original).getEnabled(), ((Policy)this.updated).getEnabled());
            this.updateRules(((Policy)this.original).getRules(), ((Policy)this.updated).getRules());
        }

        private void updateRules(List<Rule> origRules, List<Rule> updatedRules) {
            ArrayList deletedRules = new ArrayList();
            ArrayList addedRules = new ArrayList();
            this.recordListChange("rules", origRules, updatedRules, addedRules, deletedRules, EntityUtil.ruleMatch);
            for (Rule updated : updatedRules) {
                Rule stored = origRules.stream().filter(c -> EntityUtil.ruleMatch.test((Rule)c, updated)).findAny().orElse(null);
                if (stored == null) continue;
                this.updateRuleDescription(stored, updated);
                this.updateRuleEffect(stored, updated);
                this.updateRuleOperations(stored, updated);
                this.updateRuleResources(stored, updated);
                this.updateRuleCondition(stored, updated);
            }
        }

        private void updateRuleDescription(Rule stored, Rule updated) {
            String ruleField = EntityUtil.getRuleField(stored, "description");
            this.recordChange(ruleField, stored.getDescription(), updated.getDescription());
        }

        private void updateRuleEffect(Rule stored, Rule updated) {
            String ruleField = EntityUtil.getRuleField(stored, "effect");
            this.recordChange(ruleField, stored.getEffect(), updated.getEffect());
        }

        private void updateRuleOperations(Rule stored, Rule updated) {
            String ruleField = EntityUtil.getRuleField(stored, "operations");
            this.recordChange(ruleField, stored.getOperations(), updated.getOperations());
        }

        private void updateRuleResources(Rule stored, Rule updated) {
            String ruleField = EntityUtil.getRuleField(stored, "resources");
            this.recordChange(ruleField, stored.getResources(), updated.getResources());
        }

        private void updateRuleCondition(Rule stored, Rule updated) {
            String ruleField = EntityUtil.getRuleField(stored, "condition");
            this.recordChange(ruleField, stored.getCondition(), updated.getCondition());
        }
    }
}

