/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.migration.api;

import java.util.List;
import org.jdbi.v3.core.Handle;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.jdbi3.MigrationDAO;
import org.openmetadata.service.migration.api.MigrationProcess;
import org.openmetadata.service.migration.context.MigrationContext;
import org.openmetadata.service.migration.context.MigrationOps;
import org.openmetadata.service.migration.utils.MigrationFile;
import org.openmetadata.service.migration.utils.v110.MigrationUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrationProcessImpl
implements MigrationProcess {
    private static final Logger LOG = LoggerFactory.getLogger(MigrationProcessImpl.class);
    private CollectionDAO collectionDAO;
    private MigrationDAO migrationDAO;
    private Handle handle;
    private final MigrationFile migrationFile;
    public MigrationContext context;

    public MigrationProcessImpl(MigrationFile migrationFile) {
        this.migrationFile = migrationFile;
    }

    @Override
    public void initialize(Handle handle) {
        this.handle = handle;
        this.collectionDAO = (CollectionDAO)handle.attach(CollectionDAO.class);
        this.migrationDAO = (MigrationDAO)handle.attach(MigrationDAO.class);
    }

    @Override
    public List<MigrationOps> getMigrationOps() {
        return List.of();
    }

    @Override
    public String getDatabaseConnectionType() {
        return this.migrationFile.connectionType.toString();
    }

    @Override
    public String getVersion() {
        return this.migrationFile.version;
    }

    @Override
    public String getMigrationsPath() {
        return this.migrationFile.getMigrationsFilePath();
    }

    @Override
    public String getSchemaChangesFilePath() {
        return this.migrationFile.getSchemaChangesFile();
    }

    @Override
    public String getPostDDLScriptFilePath() {
        return this.migrationFile.getPostDDLScriptFile();
    }

    @Override
    public void runSchemaChanges() {
        MigrationUtil.performSqlExecutionAndUpdate(this.handle, this.migrationDAO, this.migrationFile.getSchemaChanges(), this.migrationFile.version);
    }

    @Override
    public void runDataMigration() {
    }

    @Override
    public void runPostDDLScripts() {
        MigrationUtil.performSqlExecutionAndUpdate(this.handle, this.migrationDAO, this.migrationFile.getPostDDLScripts(), this.migrationFile.version);
    }

    @Override
    public void close() {
        if (this.handle != null) {
            this.handle.close();
        }
    }

    public MigrationContext getContext() {
        return this.context;
    }
}

