/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.databases;

import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.ExampleObject;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.UUID;
import javax.json.JsonPatch;
import javax.validation.Valid;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.PATCH;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.CreateEntity;
import org.openmetadata.schema.api.VoteRequest;
import org.openmetadata.schema.api.data.CreateDatabaseSchema;
import org.openmetadata.schema.api.data.RestoreEntity;
import org.openmetadata.schema.entity.data.DatabaseSchema;
import org.openmetadata.schema.type.ChangeEvent;
import org.openmetadata.schema.type.EntityHistory;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.MetadataOperation;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.DatabaseSchemaRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.resources.Collection;
import org.openmetadata.service.resources.EntityResource;
import org.openmetadata.service.security.Authorizer;
import org.openmetadata.service.util.ResultList;

@Path(value="/v1/databaseSchemas")
@Tag(name="Database Schemas", description="A `Database Schema` is collection of tables, views, stored procedures, and other database objects.")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Collection(name="databaseSchemas")
public class DatabaseSchemaResource
extends EntityResource<DatabaseSchema, DatabaseSchemaRepository> {
    public static final String COLLECTION_PATH = "v1/databaseSchemas/";
    static final String FIELDS = "owner,tables,usageSummary,tags,extension,domain";

    @Override
    public DatabaseSchema addHref(UriInfo uriInfo, DatabaseSchema schema) {
        super.addHref(uriInfo, schema);
        Entity.withHref(uriInfo, schema.getTables());
        Entity.withHref(uriInfo, schema.getService());
        Entity.withHref(uriInfo, schema.getDatabase());
        return schema;
    }

    public DatabaseSchemaResource(Authorizer authorizer) {
        super("databaseSchema", authorizer);
    }

    @Override
    protected List<MetadataOperation> getEntitySpecificOperations() {
        this.addViewOperation("tables", MetadataOperation.VIEW_BASIC);
        this.addViewOperation("usageSummary", MetadataOperation.VIEW_USAGE);
        return CommonUtil.listOf((Object[])new MetadataOperation[]{MetadataOperation.VIEW_USAGE, MetadataOperation.EDIT_USAGE});
    }

    @GET
    @Operation(operationId="listDBSchemas", summary="List database schemas", description="Get a list of database schemas, optionally filtered by `database` it belongs to. Use `fields` parameter to get only necessary fields. Use cursor-based pagination to limit the number entries in the list using `limit` and `before` or `after` query params.", responses={@ApiResponse(responseCode="200", description="List of database schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchemaList.class))})})
    public ResultList<DatabaseSchema> list(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tables,usageSummary,tags,extension,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Filter schemas by database name", schema=@Schema(type="string", example="customerDatabase")) @QueryParam(value="database") String databaseParam, @Parameter(description="Limit the number schemas returned. (1 to 1000000, default = 10)") @DefaultValue(value="10") @QueryParam(value="limit") @Min(value=0L) @Max(value=1000000L) @Min(value=0L) @Max(value=1000000L) int limitParam, @Parameter(description="Returns list of schemas before this cursor", schema=@Schema(type="string")) @QueryParam(value="before") String before, @Parameter(description="Returns list of schemas after this cursor", schema=@Schema(type="string")) @QueryParam(value="after") String after, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        ListFilter filter = new ListFilter(include).addQueryParam("database", databaseParam);
        return this.listInternal(uriInfo, securityContext, fieldsParam, filter, limitParam, before, after);
    }

    @GET
    @Path(value="/{id}/versions")
    @Operation(operationId="listAllDBSchemaVersion", summary="List schema versions", description="Get a list of all the versions of a schema identified by `Id`", responses={@ApiResponse(responseCode="200", description="List of schema versions", content={@Content(mediaType="application/json", schema=@Schema(implementation=EntityHistory.class))})})
    public EntityHistory listVersions(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Database schema Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return super.listVersionsInternal(securityContext, id);
    }

    @GET
    @Path(value="/{id}")
    @Operation(operationId="getDBSchemaByID", summary="Get a schema by Id", description="Get a database schema by `Id`.", responses={@ApiResponse(responseCode="200", description="The schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))}), @ApiResponse(responseCode="404", description="Schema for instance {id} is not found")})
    public DatabaseSchema get(@Context UriInfo uriInfo, @Parameter(description="Database schema Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tables,usageSummary,tags,extension,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DatabaseSchema)this.getInternal(uriInfo, securityContext, id, fieldsParam, include);
    }

    @GET
    @Path(value="/name/{fqn}")
    @Operation(operationId="getDBSchemaByFQN", summary="Get a schema by fully qualified name", description="Get a database schema by fully qualified name.", responses={@ApiResponse(responseCode="200", description="The schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))}), @ApiResponse(responseCode="404", description="Database schema for instance {fqn} is not found")})
    public DatabaseSchema getByName(@Context UriInfo uriInfo, @Parameter(description="Fully qualified name of the database schema", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn, @Context SecurityContext securityContext, @Parameter(description="Fields requested in the returned resource", schema=@Schema(type="string", example="owner,tables,usageSummary,tags,extension,domain")) @QueryParam(value="fields") String fieldsParam, @Parameter(description="Include all, deleted, or non-deleted entities.", schema=@Schema(implementation=Include.class)) @QueryParam(value="include") @DefaultValue(value="non-deleted") Include include) {
        return (DatabaseSchema)this.getByNameInternal(uriInfo, securityContext, fqn, fieldsParam, include);
    }

    @GET
    @Path(value="/{id}/versions/{version}")
    @Operation(operationId="getSpecificDBSchemaVersion", summary="Get a version of the schema", description="Get a version of the database schema by given `Id`", responses={@ApiResponse(responseCode="200", description="database schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))}), @ApiResponse(responseCode="404", description="Database schema for instance {id} and version {version} is not found")})
    public DatabaseSchema getVersion(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Database schema Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Parameter(description="Database schema version number in the form `major`.`minor`", schema=@Schema(type="string", example="0.1 or 1.1")) @PathParam(value="version") String version) {
        return (DatabaseSchema)super.getVersionInternal(securityContext, id, version);
    }

    @Override
    @POST
    @Operation(operationId="createDBSchema", summary="Create a schema", description="Create a schema under an existing `service`.", responses={@ApiResponse(responseCode="200", description="The database schema", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))}), @ApiResponse(responseCode="400", description="Bad request")})
    public Response create(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDatabaseSchema create) {
        DatabaseSchema schema = this.getDatabaseSchema(create, securityContext.getUserPrincipal().getName());
        return this.create(uriInfo, securityContext, schema);
    }

    @PATCH
    @Path(value="/{id}")
    @Operation(operationId="patchDBSchema", summary="Update a database schema", description="Update an existing database schema using JsonPatch.", externalDocs=@ExternalDocumentation(description="JsonPatch RFC", url="https://tools.ietf.org/html/rfc6902"))
    @Consumes(value={"application/json-patch+json"})
    public Response patch(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Database schema Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @RequestBody(description="JsonPatch with array of operations", content={@Content(mediaType="application/json-patch+json", examples={@ExampleObject(value="[{op:remove, path:/a},{op:add, path: /b, value: val}]")})}) JsonPatch patch) {
        return this.patchInternal(uriInfo, securityContext, id, patch);
    }

    @Override
    @PUT
    @Operation(operationId="createOrUpdateDBSchema", summary="Create or update schema", description="Create a database schema, if it does not exist or update an existing database schema.", responses={@ApiResponse(responseCode="200", description="The updated schema ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))})})
    public Response createOrUpdate(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid CreateDatabaseSchema create) {
        DatabaseSchema schema = this.getDatabaseSchema(create, securityContext.getUserPrincipal().getName());
        return this.createOrUpdate(uriInfo, securityContext, schema);
    }

    @PUT
    @Path(value="/{id}/vote")
    @Operation(operationId="updateVoteForEntity", summary="Update Vote for a Entity", description="Update vote for a Entity", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", schema=@Schema(implementation=ChangeEvent.class))}), @ApiResponse(responseCode="404", description="model for instance {id} is not found")})
    public Response updateVote(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Id of the Entity", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id, @Valid VoteRequest request) {
        return ((DatabaseSchemaRepository)this.repository).updateVote(securityContext.getUserPrincipal().getName(), id, request).toResponse();
    }

    @DELETE
    @Path(value="/{id}")
    @Operation(operationId="deleteDBSchema", summary="Delete a schema by Id", description="Delete a schema by `Id`. Schema can only be deleted if it has no tables.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Schema for instance {id} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Recursively delete this entity and it's children. (Default `false`)") @DefaultValue(value="false") @QueryParam(value="recursive") boolean recursive, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Database schema Id", schema=@Schema(type="UUID")) @PathParam(value="id") UUID id) {
        return this.delete(uriInfo, securityContext, id, recursive, hardDelete);
    }

    @DELETE
    @Path(value="/name/{fqn}")
    @Operation(operationId="deleteDBSchemaByFQN", summary="Delete a schema by fully qualified name", description="Delete a schema by `fullyQualifiedName`. Schema can only be deleted if it has no tables.", responses={@ApiResponse(responseCode="200", description="OK"), @ApiResponse(responseCode="404", description="Schema for instance {fqn} is not found")})
    public Response delete(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Parameter(description="Hard delete the entity. (Default = `false`)") @QueryParam(value="hardDelete") @DefaultValue(value="false") boolean hardDelete, @Parameter(description="Name of the DBSchema", schema=@Schema(type="string")) @PathParam(value="fqn") String fqn) {
        return this.deleteByName(uriInfo, securityContext, fqn, false, hardDelete);
    }

    @PUT
    @Path(value="/restore")
    @Operation(operationId="restore", summary="Restore a soft deleted database schema.", description="Restore a soft deleted database schema.", responses={@ApiResponse(responseCode="200", description="Successfully restored the DatabaseSchema ", content={@Content(mediaType="application/json", schema=@Schema(implementation=DatabaseSchema.class))})})
    public Response restoreDatabaseSchema(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @Valid RestoreEntity restore) {
        return this.restoreEntity(uriInfo, securityContext, restore.getId());
    }

    private DatabaseSchema getDatabaseSchema(CreateDatabaseSchema create, String user) {
        return ((DatabaseSchemaRepository)this.repository).copy(new DatabaseSchema(), (CreateEntity)create, user).withDatabase(this.getEntityReference("database", create.getDatabase())).withTags(create.getTags()).withSourceUrl(create.getSourceUrl()).withRetentionPeriod(create.getRetentionPeriod());
    }

    public static class DatabaseSchemaList
    extends ResultList<DatabaseSchema> {
    }
}

