/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class GlossaryTermIndex
implements SearchIndex {
    final GlossaryTerm glossaryTerm;
    final List<String> excludeFields = List.of("changeDescription");

    public GlossaryTermIndex(GlossaryTerm glossaryTerm) {
        this.glossaryTerm = glossaryTerm;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.glossaryTerm);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getName()).weight(5).build());
        if (this.glossaryTerm.getDisplayName() != null && !this.glossaryTerm.getDisplayName().isEmpty()) {
            suggest.add(SearchSuggest.builder().input(this.glossaryTerm.getDisplayName()).weight(10).build());
        }
        doc.put("fqnParts", this.getFQNParts(this.glossaryTerm.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "glossaryTerm");
        if (this.glossaryTerm.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.glossaryTerm.getOwner()));
        }
        if (this.glossaryTerm.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.glossaryTerm.getDomain()));
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(10.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(10.0f));
        fields.put("name.keyword", Float.valueOf(1.0f));
        fields.put("name.ngram", Float.valueOf(1.0f));
        fields.put("fullyQualifiedName.keyword", Float.valueOf(3.0f));
        fields.put("fullyQualifiedName.ngram", Float.valueOf(1.0f));
        fields.put("synonyms", Float.valueOf(5.0f));
        fields.put("synonyms.ngram", Float.valueOf(1.0f));
        fields.put("description", Float.valueOf(3.0f));
        fields.put("glossary.name", Float.valueOf(5.0f));
        fields.put("glossary.displayName", Float.valueOf(5.0f));
        fields.put("glossary.displayName.ngram", Float.valueOf(1.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

