/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.entity.data.Pipeline;
import org.openmetadata.schema.type.Task;
import org.openmetadata.service.Entity;
import org.openmetadata.service.search.ParseTags;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class PipelineIndex
implements SearchIndex {
    final Pipeline pipeline;
    final List<String> excludeFields = List.of("changeDescription");

    public PipelineIndex(Pipeline pipeline) {
        this.pipeline = pipeline;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.pipeline);
        SearchIndexUtils.removeNonIndexableFields(doc, this.excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> serviceSuggest = new ArrayList<SearchSuggest>();
        ArrayList<SearchSuggest> taskSuggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.pipeline.getFullyQualifiedName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.pipeline.getDisplayName()).weight(10).build());
        serviceSuggest.add(SearchSuggest.builder().input(this.pipeline.getService().getName()).weight(5).build());
        if (this.pipeline.getTasks() != null) {
            for (Task task : this.pipeline.getTasks()) {
                taskSuggest.add(SearchSuggest.builder().input(task.getName()).weight(5).build());
            }
        }
        ParseTags parseTags = new ParseTags(Entity.getEntityTags("pipeline", (EntityInterface)this.pipeline));
        doc.put("name", this.pipeline.getName() != null ? this.pipeline.getName() : this.pipeline.getDisplayName());
        doc.put("displayName", this.pipeline.getDisplayName() != null ? this.pipeline.getDisplayName() : this.pipeline.getName());
        doc.put("followers", SearchIndexUtils.parseFollowers(this.pipeline.getFollowers()));
        doc.put("tags", parseTags.getTags());
        doc.put("tier", parseTags.getTierTag());
        doc.put("suggest", suggest);
        doc.put("task_suggest", taskSuggest);
        doc.put("service_suggest", serviceSuggest);
        doc.put("entityType", "pipeline");
        doc.put("serviceType", this.pipeline.getServiceType());
        doc.put("fqnParts", this.getFQNParts(this.pipeline.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        if (this.pipeline.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.pipeline.getOwner()));
        }
        if (this.pipeline.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.pipeline.getDomain()));
        }
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("displayName.ngram", Float.valueOf(1.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("description", Float.valueOf(1.0f));
        fields.put("tasks.name", Float.valueOf(2.0f));
        fields.put("tasks.description", Float.valueOf(1.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

