/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.util;

import org.openmetadata.schema.auth.JWTAuthMechanism;
import org.openmetadata.schema.auth.SSOAuthMechanism;
import org.openmetadata.schema.entity.teams.AuthenticationMechanism;
import org.openmetadata.service.secrets.converter.ClassConverterFactory;

public final class AuthenticationMechanismBuilder {
    private AuthenticationMechanismBuilder() {
    }

    public static AuthenticationMechanism addDefinedConfig(AuthenticationMechanism authMechanism) {
        if (authMechanism != null) {
            if (AuthenticationMechanism.AuthType.JWT.equals((Object)authMechanism.getAuthType())) {
                authMechanism.setConfig(ClassConverterFactory.getConverter(JWTAuthMechanism.class).convert(authMechanism.getConfig()));
            } else if (AuthenticationMechanism.AuthType.SSO.equals((Object)authMechanism.getAuthType())) {
                authMechanism.setConfig(ClassConverterFactory.getConverter(SSOAuthMechanism.class).convert(authMechanism.getConfig()));
            }
        }
        return authMechanism;
    }
}

