/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.workflows.searchIndex;

import java.util.List;
import java.util.Map;
import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.schema.type.Include;
import org.openmetadata.service.Entity;
import org.openmetadata.service.jdbi3.EntityRepository;
import org.openmetadata.service.jdbi3.ListFilter;
import org.openmetadata.service.util.RestUtil;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Source;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PaginatedEntitiesSource
implements Source<ResultList<? extends EntityInterface>> {
    private static final Logger LOG = LoggerFactory.getLogger(PaginatedEntitiesSource.class);
    private final int batchSize;
    private final String entityType;
    private final List<String> fields;
    private final StepStats stats = new StepStats();
    private String lastFailedCursor = null;
    private String cursor = RestUtil.encodeCursor("0");
    private boolean isDone = false;

    public PaginatedEntitiesSource(String entityType, int batchSize, List<String> fields) {
        this.entityType = entityType;
        this.batchSize = batchSize;
        this.fields = fields;
        this.stats.setTotalRecords(Integer.valueOf(Entity.getEntityRepository(entityType).getDao().listTotalCount()));
    }

    @Override
    public ResultList<? extends EntityInterface> readNext(Map<String, Object> contextData) {
        if (!this.isDone) {
            ResultList<? extends EntityInterface> data = this.read(this.cursor);
            this.cursor = data.getPaging().getAfter();
            if (this.cursor == null) {
                this.isDone = true;
            }
            return data;
        }
        return null;
    }

    private ResultList<? extends EntityInterface> read(String cursor) {
        LOG.debug("[PaginatedEntitiesSource] Fetching a Batch of Size: {} ", (Object)this.batchSize);
        EntityRepository<? extends EntityInterface> entityRepository = Entity.getEntityRepository(this.entityType);
        ResultList<? extends EntityInterface> result = entityRepository.listAfterWithSkipFailure(null, Entity.getFields(this.entityType, this.fields), new ListFilter(Include.ALL), this.batchSize, cursor);
        if (!result.getErrors().isEmpty()) {
            this.lastFailedCursor = this.cursor;
            result.getErrors().forEach(error -> LOG.error("[PaginatedEntitiesSource] Failed in getting Record, After Cursor : {} , RECORD: {}", (Object)result.getPaging().getAfter(), error));
        }
        LOG.debug("[PaginatedEntitiesSource] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{this.batchSize, result.getData().size(), result.getErrors().size()});
        this.updateStats(result.getData().size(), result.getErrors().size());
        return result;
    }

    @Override
    public void reset() {
        this.cursor = null;
        this.isDone = false;
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }

    public String getLastFailedCursor() {
        return this.lastFailedCursor;
    }

    public void setCursor(String cursor) {
        this.cursor = cursor;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public String getEntityType() {
        return this.entityType;
    }

    public List<String> getFields() {
        return this.fields;
    }

    public boolean isDone() {
        return this.isDone;
    }
}

