/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.Configuration;
import io.dropwizard.db.DataSourceFactory;
import io.dropwizard.health.conf.HealthConfiguration;
import io.federecio.dropwizard.swagger.SwaggerBundleConfiguration;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.openmetadata.api.configuration.ApplicationConfiguration;
import org.openmetadata.api.configuration.ChangeEventConfiguration;
import org.openmetadata.schema.api.configuration.events.EventHandlerConfiguration;
import org.openmetadata.schema.api.configuration.pipelineServiceClient.PipelineServiceClientConfiguration;
import org.openmetadata.schema.api.fernet.FernetConfiguration;
import org.openmetadata.schema.api.security.AuthenticationConfiguration;
import org.openmetadata.schema.api.security.AuthorizerConfiguration;
import org.openmetadata.schema.api.security.jwt.JWTTokenConfiguration;
import org.openmetadata.schema.email.SmtpSettings;
import org.openmetadata.schema.security.secrets.SecretsManagerConfiguration;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.service.config.OMWebConfiguration;
import org.openmetadata.service.migration.MigrationConfiguration;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;

public class OpenMetadataApplicationConfig
extends Configuration {
    @JsonProperty(value="database")
    @NotNull
    @Valid
    private DataSourceFactory dataSourceFactory;
    @JsonProperty(value="swagger")
    private SwaggerBundleConfiguration swaggerBundleConfig;
    @JsonProperty(value="authorizerConfiguration")
    private AuthorizerConfiguration authorizerConfiguration;
    @JsonProperty(value="authenticationConfiguration")
    private AuthenticationConfiguration authenticationConfiguration;
    @JsonProperty(value="jwtTokenConfiguration")
    private JWTTokenConfiguration jwtTokenConfiguration;
    @JsonProperty(value="elasticsearch")
    private ElasticSearchConfiguration elasticSearchConfiguration;
    @JsonProperty(value="eventHandlerConfiguration")
    private EventHandlerConfiguration eventHandlerConfiguration;
    @JsonProperty(value="pipelineServiceClientConfiguration")
    private PipelineServiceClientConfiguration pipelineServiceClientConfiguration;
    @JsonProperty(value="migrationConfiguration")
    @NotNull
    private MigrationConfiguration migrationConfiguration;
    @JsonProperty(value="fernetConfiguration")
    private FernetConfiguration fernetConfiguration;
    @JsonProperty(value="health")
    @NotNull
    @Valid
    private HealthConfiguration healthConfiguration = new HealthConfiguration();
    @JsonProperty(value="applicationConfig")
    private ApplicationConfiguration applicationConfiguration = new ApplicationConfiguration();
    @JsonProperty(value="secretsManagerConfiguration")
    private SecretsManagerConfiguration secretsManagerConfiguration;
    @JsonProperty(value="eventMonitoringConfiguration")
    private EventMonitorConfiguration eventMonitorConfiguration;
    @JsonProperty(value="clusterName")
    private String clusterName;
    @JsonProperty(value="email")
    private SmtpSettings smtpSettings;
    @Valid
    @NotNull
    @JsonProperty(value="web")
    private OMWebConfiguration webConfiguration = new OMWebConfiguration();
    @JsonProperty(value="changeEventConfig")
    private ChangeEventConfiguration changeEventConfiguration;

    public String toString() {
        return "catalogConfig{, dataSourceFactory=" + String.valueOf(this.dataSourceFactory) + ", swaggerBundleConfig=" + String.valueOf(this.swaggerBundleConfig) + ", authorizerConfiguration=" + String.valueOf(this.authorizerConfiguration) + "}";
    }

    public DataSourceFactory getDataSourceFactory() {
        return this.dataSourceFactory;
    }

    public SwaggerBundleConfiguration getSwaggerBundleConfig() {
        return this.swaggerBundleConfig;
    }

    public AuthorizerConfiguration getAuthorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public AuthenticationConfiguration getAuthenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public JWTTokenConfiguration getJwtTokenConfiguration() {
        return this.jwtTokenConfiguration;
    }

    public ElasticSearchConfiguration getElasticSearchConfiguration() {
        return this.elasticSearchConfiguration;
    }

    public EventHandlerConfiguration getEventHandlerConfiguration() {
        return this.eventHandlerConfiguration;
    }

    public PipelineServiceClientConfiguration getPipelineServiceClientConfiguration() {
        return this.pipelineServiceClientConfiguration;
    }

    public MigrationConfiguration getMigrationConfiguration() {
        return this.migrationConfiguration;
    }

    public FernetConfiguration getFernetConfiguration() {
        return this.fernetConfiguration;
    }

    public HealthConfiguration getHealthConfiguration() {
        return this.healthConfiguration;
    }

    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    public SecretsManagerConfiguration getSecretsManagerConfiguration() {
        return this.secretsManagerConfiguration;
    }

    public EventMonitorConfiguration getEventMonitorConfiguration() {
        return this.eventMonitorConfiguration;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public SmtpSettings getSmtpSettings() {
        return this.smtpSettings;
    }

    public OMWebConfiguration getWebConfiguration() {
        return this.webConfiguration;
    }

    public ChangeEventConfiguration getChangeEventConfiguration() {
        return this.changeEventConfiguration;
    }

    @JsonProperty(value="database")
    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }

    @JsonProperty(value="swagger")
    public void setSwaggerBundleConfig(SwaggerBundleConfiguration swaggerBundleConfig) {
        this.swaggerBundleConfig = swaggerBundleConfig;
    }

    @JsonProperty(value="authorizerConfiguration")
    public void setAuthorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
        this.authorizerConfiguration = authorizerConfiguration;
    }

    @JsonProperty(value="authenticationConfiguration")
    public void setAuthenticationConfiguration(AuthenticationConfiguration authenticationConfiguration) {
        this.authenticationConfiguration = authenticationConfiguration;
    }

    @JsonProperty(value="jwtTokenConfiguration")
    public void setJwtTokenConfiguration(JWTTokenConfiguration jwtTokenConfiguration) {
        this.jwtTokenConfiguration = jwtTokenConfiguration;
    }

    @JsonProperty(value="elasticsearch")
    public void setElasticSearchConfiguration(ElasticSearchConfiguration elasticSearchConfiguration) {
        this.elasticSearchConfiguration = elasticSearchConfiguration;
    }

    @JsonProperty(value="eventHandlerConfiguration")
    public void setEventHandlerConfiguration(EventHandlerConfiguration eventHandlerConfiguration) {
        this.eventHandlerConfiguration = eventHandlerConfiguration;
    }

    @JsonProperty(value="pipelineServiceClientConfiguration")
    public void setPipelineServiceClientConfiguration(PipelineServiceClientConfiguration pipelineServiceClientConfiguration) {
        this.pipelineServiceClientConfiguration = pipelineServiceClientConfiguration;
    }

    @JsonProperty(value="migrationConfiguration")
    public void setMigrationConfiguration(MigrationConfiguration migrationConfiguration) {
        this.migrationConfiguration = migrationConfiguration;
    }

    @JsonProperty(value="fernetConfiguration")
    public void setFernetConfiguration(FernetConfiguration fernetConfiguration) {
        this.fernetConfiguration = fernetConfiguration;
    }

    @JsonProperty(value="health")
    public void setHealthConfiguration(HealthConfiguration healthConfiguration) {
        this.healthConfiguration = healthConfiguration;
    }

    @JsonProperty(value="applicationConfig")
    public void setApplicationConfiguration(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @JsonProperty(value="secretsManagerConfiguration")
    public void setSecretsManagerConfiguration(SecretsManagerConfiguration secretsManagerConfiguration) {
        this.secretsManagerConfiguration = secretsManagerConfiguration;
    }

    @JsonProperty(value="eventMonitoringConfiguration")
    public void setEventMonitorConfiguration(EventMonitorConfiguration eventMonitorConfiguration) {
        this.eventMonitorConfiguration = eventMonitorConfiguration;
    }

    @JsonProperty(value="clusterName")
    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    @JsonProperty(value="email")
    public void setSmtpSettings(SmtpSettings smtpSettings) {
        this.smtpSettings = smtpSettings;
    }

    @JsonProperty(value="web")
    public void setWebConfiguration(OMWebConfiguration webConfiguration) {
        this.webConfiguration = webConfiguration;
    }

    @JsonProperty(value="changeEventConfig")
    public void setChangeEventConfiguration(ChangeEventConfiguration changeEventConfiguration) {
        this.changeEventConfiguration = changeEventConfiguration;
    }
}

