/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.entity.app.AppType;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationHandler.class);

    private ApplicationHandler() {
    }

    public static void triggerApplicationOnDemand(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        try {
            Class<?> clz = Class.forName(app.getClassName());
            Object resource = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method initMethod = resource.getClass().getMethod("init", App.class, CollectionDAO.class, SearchRepository.class);
            initMethod.invoke(resource, app, daoCollection, searchRepository);
            Method triggerOnDemandMethod = resource.getClass().getMethod("triggerOnDemand", new Class[0]);
            triggerOnDemandMethod.invoke(resource, new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Exception encountered", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static void scheduleApplication(App app, CollectionDAO daoCollection, SearchRepository searchRepository) {
        try {
            Class<?> clz = Class.forName(app.getClassName());
            Object resource = clz.getConstructor(new Class[0]).newInstance(new Object[0]);
            Method initMethod = resource.getClass().getMethod("init", App.class, CollectionDAO.class, SearchRepository.class);
            initMethod.invoke(resource, app, daoCollection, searchRepository);
            if (app.getAppType() == AppType.Internal) {
                Method scheduleMethod = resource.getClass().getMethod("scheduleInternal", new Class[0]);
                scheduleMethod.invoke(resource, new Object[0]);
            } else if (app.getAppType() == AppType.External) {
                Method scheduleMethod = resource.getClass().getMethod("initializeExternalApp", new Class[0]);
                scheduleMethod.invoke(resource, new Object[0]);
            }
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            LOG.error("Exception encountered", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

