/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.apps.bundles.searchIndex;

import es.org.elasticsearch.action.bulk.BulkItemResponse;
import es.org.elasticsearch.action.bulk.BulkRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.openmetadata.common.utils.CommonUtil;
import org.openmetadata.schema.entity.app.App;
import org.openmetadata.schema.service.configuration.elasticsearch.ElasticSearchConfiguration;
import org.openmetadata.schema.system.EventPublisherJob;
import org.openmetadata.schema.system.Failure;
import org.openmetadata.schema.system.FailureDetails;
import org.openmetadata.schema.system.Stats;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.apps.AbstractNativeApplication;
import org.openmetadata.service.exception.ProcessorException;
import org.openmetadata.service.exception.SinkException;
import org.openmetadata.service.exception.SourceException;
import org.openmetadata.service.jdbi3.CollectionDAO;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.search.elasticsearch.ElasticSearchDataInsightProcessor;
import org.openmetadata.service.search.elasticsearch.ElasticSearchEntitiesProcessor;
import org.openmetadata.service.search.elasticsearch.ElasticSearchIndexSink;
import org.openmetadata.service.search.models.IndexMapping;
import org.openmetadata.service.search.opensearch.OpenSearchDataInsightProcessor;
import org.openmetadata.service.search.opensearch.OpenSearchEntitiesProcessor;
import org.openmetadata.service.search.opensearch.OpenSearchIndexSink;
import org.openmetadata.service.socket.WebSocketManager;
import org.openmetadata.service.util.JsonUtils;
import org.openmetadata.service.util.ResultList;
import org.openmetadata.service.workflows.interfaces.Processor;
import org.openmetadata.service.workflows.interfaces.Sink;
import org.openmetadata.service.workflows.searchIndex.PaginatedDataInsightSource;
import org.openmetadata.service.workflows.searchIndex.PaginatedEntitiesSource;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.quartz.JobExecutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import os.org.opensearch.action.bulk.BulkItemResponse;
import os.org.opensearch.action.bulk.BulkResponse;

public class SearchIndexApp
extends AbstractNativeApplication {
    private static final Logger LOG = LoggerFactory.getLogger(SearchIndexApp.class);
    private static final String ENTITY_TYPE_ERROR_MSG = "EntityType: %s %n Cause: %s %n Stack: %s";
    private List<PaginatedEntitiesSource> paginatedEntitiesSources = new ArrayList<PaginatedEntitiesSource>();
    private List<PaginatedDataInsightSource> paginatedDataInsightSources = new ArrayList<PaginatedDataInsightSource>();
    private Processor entityProcessor;
    private Processor dataInsightProcessor;
    private Sink searchIndexSink;
    EventPublisherJob jobData;
    private volatile boolean stopped = false;

    @Override
    public void init(App app, CollectionDAO dao, SearchRepository searchRepository) {
        EventPublisherJob request;
        super.init(app, dao, searchRepository);
        this.jobData = request = JsonUtils.convertValue(app.getAppConfiguration(), EventPublisherJob.class).withStats(new Stats()).withFailure(new Failure());
        request.getEntities().forEach(entityType -> {
            if (!ReindexingUtil.isDataInsightIndex(entityType)) {
                List<String> fields = List.of("*");
                PaginatedEntitiesSource source = new PaginatedEntitiesSource((String)entityType, this.jobData.getBatchSize(), fields);
                if (!CommonUtil.nullOrEmpty((String)request.getAfterCursor())) {
                    source.setCursor(request.getAfterCursor());
                }
                this.paginatedEntitiesSources.add(source);
            } else {
                this.paginatedDataInsightSources.add(new PaginatedDataInsightSource(dao, (String)entityType, this.jobData.getBatchSize()));
            }
        });
        if (searchRepository.getSearchType().equals((Object)ElasticSearchConfiguration.SearchType.OPENSEARCH)) {
            this.entityProcessor = new OpenSearchEntitiesProcessor();
            this.dataInsightProcessor = new OpenSearchDataInsightProcessor();
            this.searchIndexSink = new OpenSearchIndexSink(searchRepository);
        } else {
            this.entityProcessor = new ElasticSearchEntitiesProcessor();
            this.dataInsightProcessor = new ElasticSearchDataInsightProcessor();
            this.searchIndexSink = new ElasticSearchIndexSink(searchRepository);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startApp(JobExecutionContext jobExecutionContext) {
        try {
            LOG.info("Executing Reindexing Job with JobData : {}", (Object)this.jobData);
            this.jobData.setStatus(EventPublisherJob.Status.RUNNING);
            this.entitiesReIndex();
            this.dataInsightReindex();
            this.updateJobStatus();
        }
        catch (Exception ex) {
            String error = String.format("Reindexing Job Has Encountered an Exception. %n Job Data: %s, %n  Stack : %s ", this.jobData.toString(), ExceptionUtils.getStackTrace((Throwable)ex));
            LOG.error(error);
            this.jobData.setStatus(EventPublisherJob.Status.FAILED);
            this.handleJobError("Failure in Job: Check Stack", error, System.currentTimeMillis());
        }
        finally {
            jobExecutionContext.getJobDetail().getJobDataMap().put("AppRunStats", (Object)this.jobData.getStats());
            this.sendUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void entitiesReIndex() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (PaginatedEntitiesSource paginatedEntitiesSource : this.paginatedEntitiesSources) {
            this.reCreateIndexes(paginatedEntitiesSource.getEntityType());
            contextData.put("entityType", paginatedEntitiesSource.getEntityType());
            while (!this.stopped && !paginatedEntitiesSource.isDone()) {
                int requestToProcess;
                long currentTime = System.currentTimeMillis();
                int failed = requestToProcess = this.jobData.getBatchSize().intValue();
                int success = 0;
                try {
                    Object resultList = paginatedEntitiesSource.readNext((Map)null);
                    requestToProcess = ((ResultList)resultList).getData().size() + ((ResultList)resultList).getErrors().size();
                    if (!((ResultList)resultList).getData().isEmpty()) {
                        if (this.searchRepository.getSearchType().equals((Object)ElasticSearchConfiguration.SearchType.OPENSEARCH)) {
                            requests = (os.org.opensearch.action.bulk.BulkRequest)this.entityProcessor.process(resultList, contextData);
                            response = (BulkResponse)this.searchIndexSink.write(requests, contextData);
                            this.handleErrorsOs((ResultList<?>)resultList, paginatedEntitiesSource.getLastFailedCursor(), response, currentTime);
                            success = this.searchRepository.getSearchClient().getSuccessFromBulkResponse(response);
                        } else {
                            requests = (BulkRequest)this.entityProcessor.process(resultList, contextData);
                            response = (es.org.elasticsearch.action.bulk.BulkResponse)this.searchIndexSink.write(requests, contextData);
                            this.handleErrorsEs((ResultList<?>)resultList, paginatedEntitiesSource.getLastFailedCursor(), (es.org.elasticsearch.action.bulk.BulkResponse)response, currentTime);
                            success = this.searchRepository.getSearchClient().getSuccessFromBulkResponse((es.org.elasticsearch.action.bulk.BulkResponse)response);
                        }
                        failed = requestToProcess - success;
                        continue;
                    }
                    failed = 0;
                }
                catch (ProcessorException px) {
                    this.handleProcessorError(px.getMessage(), String.format(ENTITY_TYPE_ERROR_MSG, paginatedEntitiesSource.getEntityType(), px.getCause(), ExceptionUtils.getStackTrace((Throwable)px)), currentTime);
                }
                catch (SinkException wx) {
                    this.handleEsSinkError(wx.getMessage(), String.format(ENTITY_TYPE_ERROR_MSG, paginatedEntitiesSource.getEntityType(), wx.getCause(), ExceptionUtils.getStackTrace((Throwable)wx)), currentTime);
                }
                finally {
                    this.updateStats(success, failed, paginatedEntitiesSource.getStats(), this.entityProcessor.getStats(), this.searchIndexSink.getStats());
                    this.sendUpdates();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dataInsightReindex() {
        HashMap<String, Object> contextData = new HashMap<String, Object>();
        for (PaginatedDataInsightSource paginatedDataInsightSource : this.paginatedDataInsightSources) {
            this.reCreateIndexes(paginatedDataInsightSource.getEntityType());
            contextData.put("entityType", paginatedDataInsightSource.getEntityType());
            while (!this.stopped && !paginatedDataInsightSource.isDone()) {
                int requestToProcess;
                long currentTime = System.currentTimeMillis();
                int failed = requestToProcess = this.jobData.getBatchSize().intValue();
                int success = 0;
                try {
                    Object resultList = paginatedDataInsightSource.readNext((Map)null);
                    requestToProcess = ((ResultList)resultList).getData().size() + ((ResultList)resultList).getErrors().size();
                    if (!((ResultList)resultList).getData().isEmpty()) {
                        if (this.searchRepository.getSearchType().equals((Object)ElasticSearchConfiguration.SearchType.OPENSEARCH)) {
                            requests = (os.org.opensearch.action.bulk.BulkRequest)this.dataInsightProcessor.process(resultList, contextData);
                            response = (BulkResponse)this.searchIndexSink.write(requests, contextData);
                            this.handleErrorsOs((ResultList<?>)resultList, "", response, currentTime);
                            success = this.searchRepository.getSearchClient().getSuccessFromBulkResponse(response);
                        } else {
                            requests = (BulkRequest)this.dataInsightProcessor.process(resultList, contextData);
                            response = (es.org.elasticsearch.action.bulk.BulkResponse)this.searchIndexSink.write(requests, contextData);
                            this.handleErrorsEs((ResultList<?>)resultList, "", (es.org.elasticsearch.action.bulk.BulkResponse)response, currentTime);
                            success = this.searchRepository.getSearchClient().getSuccessFromBulkResponse((es.org.elasticsearch.action.bulk.BulkResponse)response);
                        }
                        failed = requestToProcess - success;
                        continue;
                    }
                    failed = 0;
                }
                catch (SourceException rx) {
                    this.handleSourceError(rx.getMessage(), String.format(ENTITY_TYPE_ERROR_MSG, paginatedDataInsightSource.getEntityType(), rx.getCause(), ExceptionUtils.getStackTrace((Throwable)rx)), currentTime);
                }
                catch (ProcessorException px) {
                    this.handleProcessorError(px.getMessage(), String.format(ENTITY_TYPE_ERROR_MSG, paginatedDataInsightSource.getEntityType(), px.getCause(), ExceptionUtils.getStackTrace((Throwable)px)), currentTime);
                }
                catch (SinkException wx) {
                    this.handleEsSinkError(wx.getMessage(), String.format(ENTITY_TYPE_ERROR_MSG, paginatedDataInsightSource.getEntityType(), wx.getCause(), ExceptionUtils.getStackTrace((Throwable)wx)), currentTime);
                }
                finally {
                    this.updateStats(success, failed, paginatedDataInsightSource.getStats(), this.dataInsightProcessor.getStats(), this.searchIndexSink.getStats());
                    this.sendUpdates();
                }
            }
        }
    }

    private void sendUpdates() {
        try {
            WebSocketManager.getInstance().broadCastMessageToAll("jobStatus", JsonUtils.pojoToJson(this.jobData));
        }
        catch (Exception ex) {
            LOG.error("Failed to send updated stats with WebSocket", (Throwable)ex);
        }
    }

    public void updateStats(int currentSuccess, int currentFailed, StepStats reader, StepStats processor, StepStats writer) {
        Stats jobDataStats = this.jobData.getStats();
        StepStats stats = this.jobData.getStats().getJobStats();
        if (stats == null) {
            stats = new StepStats().withTotalRecords(Integer.valueOf(ReindexingUtil.getTotalRequestToProcess(this.jobData.getEntities(), this.collectionDAO)));
        }
        ReindexingUtil.getUpdatedStats(stats, currentSuccess, currentFailed);
        jobDataStats.setJobStats(stats);
        jobDataStats.setSourceStats(this.getTotalStatsTillCurrentRun(jobDataStats.getSourceStats(), reader));
        jobDataStats.setProcessorStats(processor);
        jobDataStats.setSinkStats(writer);
        this.jobData.setStats(jobDataStats);
    }

    private StepStats getTotalStatsTillCurrentRun(StepStats sourceStat, StepStats newInputStat) {
        if (sourceStat == null) {
            sourceStat = new StepStats();
        }
        sourceStat.setTotalRecords(Integer.valueOf(sourceStat.getTotalRecords() + newInputStat.getTotalRecords()));
        sourceStat.setProcessedRecords(Integer.valueOf(sourceStat.getProcessedRecords() + newInputStat.getProcessedRecords()));
        sourceStat.setSuccessRecords(Integer.valueOf(sourceStat.getSuccessRecords() + newInputStat.getSuccessRecords()));
        sourceStat.setFailedRecords(Integer.valueOf(sourceStat.getFailedRecords() + newInputStat.getFailedRecords()));
        return sourceStat;
    }

    private void reCreateIndexes(String entityType) {
        if (Boolean.FALSE.equals(this.jobData.getRecreateIndex())) {
            return;
        }
        IndexMapping indexType = this.searchRepository.getIndexMapping(entityType);
        this.searchRepository.deleteIndex(indexType);
        this.searchRepository.createIndex(indexType);
    }

    private void handleErrorsOs(ResultList<?> data, String lastCursor, BulkResponse response, long time) {
        this.handleSourceError(data, lastCursor, time);
        this.handleOsSinkErrors(response, time);
    }

    private void handleErrorsEs(ResultList<?> data, String lastCursor, es.org.elasticsearch.action.bulk.BulkResponse response, long time) {
        this.handleSourceError(data, lastCursor, time);
        this.handleEsSinkErrors(response, time);
    }

    private void handleSourceError(String context, String reason, long time) {
        Failure failures = this.getFailure();
        FailureDetails readerFailures = this.getFailureDetails(context, reason, time);
        failures.setSourceError(readerFailures);
        this.jobData.setFailure(failures);
    }

    private void handleProcessorError(String context, String reason, long time) {
        Failure failures = this.getFailure();
        FailureDetails processorError = this.getFailureDetails(context, reason, time);
        failures.setProcessorError(processorError);
        this.jobData.setFailure(failures);
    }

    private void handleEsSinkError(String context, String reason, long time) {
        Failure failures = this.getFailure();
        FailureDetails writerFailure = this.getFailureDetails(context, reason, time);
        failures.setSinkError(writerFailure);
        this.jobData.setFailure(failures);
    }

    private void handleJobError(String context, String reason, long time) {
        Failure failures = this.getFailure();
        FailureDetails jobFailure = this.getFailureDetails(context, reason, time);
        failures.setJobError(jobFailure);
        this.jobData.setFailure(failures);
    }

    private void handleSourceError(ResultList<?> data, String lastCursor, long time) {
        if (!data.getErrors().isEmpty()) {
            this.handleSourceError(String.format("SourceContext: After Cursor : %s, Encountered Error While Reading Data.", lastCursor), String.format("Following Entities were not fetched Successfully : %s", JsonUtils.pojoToJson(data.getErrors())), time);
        }
    }

    private void handleOsSinkErrors(BulkResponse response, long time) {
        ArrayList<FailureDetails> details = new ArrayList<FailureDetails>();
        for (os.org.opensearch.action.bulk.BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            BulkItemResponse.Failure failure = bulkItemResponse.getFailure();
            FailureDetails esFailure = new FailureDetails().withContext(String.format("EsWriterContext: Encountered Error While Writing Data %n Entity %n ID : [%s] ", failure.getId())).withLastFailedReason(String.format("Index Type: [%s], Reason: [%s] %n Trace : [%s]", failure.getIndex(), failure.getMessage(), ExceptionUtils.getStackTrace((Throwable)failure.getCause()))).withLastFailedAt(Long.valueOf(System.currentTimeMillis()));
            details.add(esFailure);
        }
        if (!details.isEmpty()) {
            this.handleEsSinkError("[EsWriter] BulkResponseItems", String.format("[BulkItemResponse] Got Following Error Responses: %n %s ", JsonUtils.pojoToJson(details)), time);
        }
    }

    private void handleEsSinkErrors(es.org.elasticsearch.action.bulk.BulkResponse response, long time) {
        ArrayList<FailureDetails> details = new ArrayList<FailureDetails>();
        for (BulkItemResponse bulkItemResponse : response) {
            if (!bulkItemResponse.isFailed()) continue;
            BulkItemResponse.Failure failure = bulkItemResponse.getFailure();
            FailureDetails esFailure = new FailureDetails().withContext(String.format("EsWriterContext: Encountered Error While Writing Data %n Entity %n ID : [%s] ", failure.getId())).withLastFailedReason(String.format("Index Type: [%s], Reason: [%s] %n Trace : [%s]", failure.getIndex(), failure.getMessage(), ExceptionUtils.getStackTrace((Throwable)failure.getCause()))).withLastFailedAt(Long.valueOf(System.currentTimeMillis()));
            details.add(esFailure);
        }
        if (!details.isEmpty()) {
            this.handleEsSinkError("[EsWriter] BulkResponseItems", String.format("[BulkItemResponse] Got Following Error Responses: %n %s ", JsonUtils.pojoToJson(details)), time);
        }
    }

    private void updateJobStatus() {
        if (this.stopped) {
            this.jobData.setStatus(EventPublisherJob.Status.STOPPED);
        } else if (this.jobData.getFailure().getSinkError() != null || this.jobData.getFailure().getSourceError() != null || this.jobData.getFailure().getProcessorError() != null) {
            this.jobData.setStatus(EventPublisherJob.Status.FAILED);
        } else {
            this.jobData.setStatus(EventPublisherJob.Status.COMPLETED);
        }
    }

    private Failure getFailure() {
        return this.jobData.getFailure() != null ? this.jobData.getFailure() : new Failure();
    }

    private FailureDetails getFailureDetails(String context, String reason, long time) {
        return new FailureDetails().withContext(context).withLastFailedReason(reason).withLastFailedAt(Long.valueOf(time));
    }

    public void stopJob() {
        this.stopped = true;
    }

    public EventPublisherJob getJobData() {
        return this.jobData;
    }
}

