/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.dataInsight;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.openmetadata.schema.dataInsight.type.PercentageOfServicesWithDescription;
import org.openmetadata.service.dataInsight.DataInsightAggregatorInterface;

public abstract class ServicesDescriptionAggregator<A, B, M, S>
implements DataInsightAggregatorInterface {
    private final A aggregations;

    public ServicesDescriptionAggregator(A aggregations) {
        this.aggregations = aggregations;
    }

    @Override
    public List<Object> aggregate() throws ParseException {
        M timestampBuckets = this.getTimestampBuckets(this.aggregations);
        ArrayList<Object> data = new ArrayList<Object>();
        for (B timestampBucket : this.getBuckets(timestampBuckets)) {
            String dateTimeString = this.getKeyAsString(timestampBucket);
            Long timestamp = this.convertDatTimeStringToTimestamp(dateTimeString);
            M serviceBuckets = this.getServiceBuckets(timestampBucket);
            for (B serviceBucket : this.getBuckets(serviceBuckets)) {
                String serviceName = this.getKeyAsString(serviceBucket);
                S sumCompletedDescriptions = this.getSumAggregations(serviceBucket, "completedDescriptionFraction");
                S sumEntityCount = this.getSumAggregations(serviceBucket, "entityCount");
                data.add(new PercentageOfServicesWithDescription().withTimestamp(timestamp).withServiceName(serviceName).withEntityCount(this.getValue(sumEntityCount)).withCompletedDescription(this.getValue(sumCompletedDescriptions)).withCompletedDescriptionFraction(Double.valueOf(this.getValue(sumCompletedDescriptions) / this.getValue(sumEntityCount))));
            }
        }
        return data;
    }

    protected abstract Double getValue(S var1);

    protected abstract S getSumAggregations(B var1, String var2);

    protected abstract M getServiceBuckets(B var1);

    protected abstract String getKeyAsString(B var1);

    protected abstract List<? extends B> getBuckets(M var1);

    protected abstract M getTimestampBuckets(A var1);
}

