/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.formatter.entity;

import org.openmetadata.schema.EntityInterface;
import org.openmetadata.schema.tests.TestCase;
import org.openmetadata.schema.tests.type.TestCaseResult;
import org.openmetadata.schema.tests.type.TestCaseStatus;
import org.openmetadata.schema.type.FieldChange;
import org.openmetadata.service.formatter.decorators.MessageDecorator;
import org.openmetadata.service.formatter.entity.EntityFormatter;
import org.openmetadata.service.formatter.util.FormatterUtil;
import org.openmetadata.service.resources.feeds.MessageParser;

public class TestCaseFormatter
implements EntityFormatter {
    private static final String TEST_RESULT_FIELD = "testCaseResult";

    @Override
    public String format(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity, FormatterUtil.CHANGE_TYPE changeType) {
        if (TEST_RESULT_FIELD.equals(fieldChange.getName())) {
            return this.transformTestCaseResult(messageFormatter, fieldChange, entity);
        }
        return FormatterUtil.transformMessage(messageFormatter, fieldChange, entity, changeType);
    }

    private String transformTestCaseResult(MessageDecorator<?> messageFormatter, FieldChange fieldChange, EntityInterface entity) {
        String testCaseName = entity.getName();
        TestCaseResult result = (TestCaseResult)fieldChange.getNewValue();
        TestCase testCaseEntity = (TestCase)entity;
        if (result != null) {
            String format = String.format("Test Case %s is %s in %s", messageFormatter.getBold(), messageFormatter.getBold(), MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN());
            return String.format(format, testCaseName, this.getStatusMessage(result.getTestCaseStatus()));
        }
        String format = String.format("Test Case %s is updated in %s", messageFormatter.getBold(), messageFormatter.getBold());
        return String.format(format, testCaseName, MessageParser.EntityLink.parse(testCaseEntity.getEntityLink()).getEntityFQN());
    }

    private String getStatusMessage(TestCaseStatus status) {
        switch (status) {
            case Success: {
                return "<span style=\"color:#48CA9E\">Passed</span>";
            }
            case Failed: {
                return "<span style=\"color:#F24822\">Failed</span>";
            }
            case Aborted: {
                return "<span style=\"color:#FFBE0E\">Aborted</span>";
            }
        }
        return status.value();
    }
}

