/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.monitoring;

import org.openmetadata.schema.monitoring.EventMonitorProvider;
import org.openmetadata.service.monitoring.CloudwatchEventMonitor;
import org.openmetadata.service.monitoring.EventMonitor;
import org.openmetadata.service.monitoring.EventMonitorConfiguration;
import org.openmetadata.service.monitoring.PrometheusEventMonitor;

public final class EventMonitorFactory {
    private EventMonitorFactory() {
    }

    public static EventMonitor createEventMonitor(EventMonitorConfiguration config, String clusterName) {
        EventMonitorProvider eventMonitorProvider;
        EventMonitorProvider eventMonitorProvider2 = eventMonitorProvider = config != null ? config.getEventMonitor() : null;
        if (eventMonitorProvider == EventMonitorProvider.CLOUDWATCH) {
            return new CloudwatchEventMonitor(eventMonitorProvider, config, clusterName);
        }
        if (eventMonitorProvider == EventMonitorProvider.PROMETHEUS) {
            return new PrometheusEventMonitor(eventMonitorProvider, config, clusterName);
        }
        throw new IllegalArgumentException("Not implemented Event monitor: " + String.valueOf(eventMonitorProvider));
    }
}

