/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.resources.tags;

import org.openmetadata.schema.entity.classification.Classification;
import org.openmetadata.schema.entity.classification.Tag;
import org.openmetadata.schema.entity.data.Glossary;
import org.openmetadata.schema.entity.data.GlossaryTerm;
import org.openmetadata.schema.type.Include;
import org.openmetadata.schema.type.TagLabel;
import org.openmetadata.service.Entity;
import org.openmetadata.service.util.FullyQualifiedName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TagLabelUtil {
    private static final Logger LOG = LoggerFactory.getLogger(TagLabelUtil.class);

    private TagLabelUtil() {
    }

    public static Classification getClassification(String classificationName) {
        return (Classification)Entity.getEntityByName("classification", classificationName, "", Include.NON_DELETED);
    }

    public static Tag getTag(String tagFqn) {
        return (Tag)Entity.getEntityByName("tag", tagFqn, "", Include.NON_DELETED);
    }

    public static Glossary getGlossary(String glossaryName) {
        return (Glossary)Entity.getEntityByName("glossary", glossaryName, "", Include.NON_DELETED);
    }

    public static GlossaryTerm getGlossaryTerm(String glossaryTermFqn) {
        return (GlossaryTerm)Entity.getEntityByName("glossaryTerm", glossaryTermFqn, "", Include.NON_DELETED);
    }

    public static void applyTagCommonFields(TagLabel label) {
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            Tag tag = TagLabelUtil.getTag(label.getTagFQN());
            label.setName(tag.getName());
            label.setDisplayName(tag.getDisplayName());
            label.setDescription(tag.getDescription());
            label.setStyle(tag.getStyle());
        } else if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            GlossaryTerm glossaryTerm = TagLabelUtil.getGlossaryTerm(label.getTagFQN());
            label.setName(glossaryTerm.getName());
            label.setDisplayName(glossaryTerm.getDisplayName());
            label.setDescription(glossaryTerm.getDescription());
            label.setStyle(glossaryTerm.getStyle());
        } else {
            throw new IllegalArgumentException("Invalid source type " + String.valueOf(label.getSource()));
        }
    }

    public static boolean mutuallyExclusive(TagLabel label) {
        boolean rootParent;
        String[] fqnParts = FullyQualifiedName.split(label.getTagFQN());
        String parentFqn = FullyQualifiedName.getParentFQN(fqnParts);
        boolean bl = rootParent = fqnParts.length == 2;
        if (label.getSource() == TagLabel.TagSource.CLASSIFICATION) {
            return rootParent ? TagLabelUtil.getClassification(parentFqn).getMutuallyExclusive() : TagLabelUtil.getTag(parentFqn).getMutuallyExclusive();
        }
        if (label.getSource() == TagLabel.TagSource.GLOSSARY) {
            return rootParent ? TagLabelUtil.getGlossary(parentFqn).getMutuallyExclusive() : TagLabelUtil.getGlossaryTerm(parentFqn).getMutuallyExclusive();
        }
        throw new IllegalArgumentException("Invalid source type " + String.valueOf(label.getSource()));
    }
}

