/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.elasticsearch;

import es.org.elasticsearch.action.bulk.BulkRequest;
import es.org.elasticsearch.action.bulk.BulkResponse;
import es.org.elasticsearch.client.RequestOptions;
import java.util.Map;
import org.openmetadata.schema.system.StepStats;
import org.openmetadata.service.exception.SinkException;
import org.openmetadata.service.search.SearchRepository;
import org.openmetadata.service.workflows.interfaces.Sink;
import org.openmetadata.service.workflows.searchIndex.ReindexingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchIndexSink
implements Sink<BulkRequest, BulkResponse> {
    private static final Logger LOG = LoggerFactory.getLogger(ElasticSearchIndexSink.class);
    private final StepStats stats = new StepStats();
    private final SearchRepository searchRepository;

    public ElasticSearchIndexSink(SearchRepository searchRepository) {
        this.searchRepository = searchRepository;
    }

    @Override
    public BulkResponse write(BulkRequest data, Map<String, Object> contextData) throws SinkException {
        LOG.debug("[EsSearchIndexSink] Processing a Batch of Size: {}", (Object)data.numberOfActions());
        try {
            BulkResponse response = this.searchRepository.getSearchClient().bulk(data, RequestOptions.DEFAULT);
            int currentSuccess = ReindexingUtil.getSuccessFromBulkResponseEs(response);
            int currentFailed = response.getItems().length - currentSuccess;
            LOG.debug("[EsSearchIndexSink] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{data.numberOfActions(), currentSuccess, currentFailed});
            this.updateStats(currentSuccess, currentFailed);
            return response;
        }
        catch (Exception e) {
            LOG.debug("[EsSearchIndexSink] Batch Stats :- Submitted : {} Success: {} Failed: {}", new Object[]{data.numberOfActions(), 0, data.numberOfActions()});
            this.updateStats(0, data.numberOfActions());
            throw new SinkException("[EsSearchIndexSink] Batch encountered Exception. Failing Completely", e);
        }
    }

    @Override
    public void updateStats(int currentSuccess, int currentFailed) {
        ReindexingUtil.getUpdatedStats(this.stats, currentSuccess, currentFailed);
    }

    @Override
    public StepStats getStats() {
        return this.stats;
    }
}

