/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.data.Chart;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class ChartIndex
implements SearchIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final Chart chart;

    public ChartIndex(Chart chart) {
        this.chart = chart;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.chart);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.chart.getName()).weight(10).build());
        suggest.add(SearchSuggest.builder().input(this.chart.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.chart.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "chart");
        if (this.chart.getOwner() != null) {
            doc.put("owner", this.getOwnerWithDisplayName(this.chart.getOwner()));
        }
        if (this.chart.getDomain() != null) {
            doc.put("domain", this.getDomainWithDisplayName(this.chart.getDomain()));
        }
        return doc;
    }
}

