/*
 * Decompiled with CFR 0.152.
 */
package org.openmetadata.service.search.indexes;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openmetadata.schema.entity.domains.Domain;
import org.openmetadata.service.search.SearchIndexUtils;
import org.openmetadata.service.search.indexes.SearchIndex;
import org.openmetadata.service.search.models.SearchSuggest;
import org.openmetadata.service.util.JsonUtils;

public class DomainIndex
implements SearchIndex {
    private static final List<String> excludeFields = List.of("changeDescription");
    final Domain domain;

    public DomainIndex(Domain domain) {
        this.domain = domain;
    }

    @Override
    public Map<String, Object> buildESDoc() {
        Map<String, Object> doc = JsonUtils.getMap(this.domain);
        SearchIndexUtils.removeNonIndexableFields(doc, excludeFields);
        ArrayList<SearchSuggest> suggest = new ArrayList<SearchSuggest>();
        suggest.add(SearchSuggest.builder().input(this.domain.getName()).weight(5).build());
        suggest.add(SearchSuggest.builder().input(this.domain.getFullyQualifiedName()).weight(5).build());
        doc.put("fqnParts", this.getFQNParts(this.domain.getFullyQualifiedName(), suggest.stream().map(SearchSuggest::getInput).collect(Collectors.toList())));
        doc.put("suggest", suggest);
        doc.put("entityType", "domain");
        return doc;
    }

    public static Map<String, Float> getFields() {
        HashMap<String, Float> fields = new HashMap<String, Float>();
        fields.put("displayName", Float.valueOf(15.0f));
        fields.put("name", Float.valueOf(15.0f));
        fields.put("displayName.keyword", Float.valueOf(25.0f));
        fields.put("name.keyword", Float.valueOf(25.0f));
        fields.put("description", Float.valueOf(1.0f));
        fields.put("fqnParts.keyword", Float.valueOf(10.0f));
        return fields;
    }
}

